/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.synthetics.model.ArtifactConfigInput;
import software.amazon.awssdk.services.synthetics.model.CanaryCodeInput;
import software.amazon.awssdk.services.synthetics.model.CanaryRunConfigInput;
import software.amazon.awssdk.services.synthetics.model.CanaryScheduleInput;
import software.amazon.awssdk.services.synthetics.model.ProvisionedResourceCleanupSetting;
import software.amazon.awssdk.services.synthetics.model.SyntheticsRequest;
import software.amazon.awssdk.services.synthetics.model.VisualReferenceInput;
import software.amazon.awssdk.services.synthetics.model.VpcConfigInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCanaryRequest
extends SyntheticsRequest
implements ToCopyableBuilder<Builder, UpdateCanaryRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::name)).setter(UpdateCanaryRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<CanaryCodeInput> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Code").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::code)).setter(UpdateCanaryRequest.setter(Builder::code)).constructor(CanaryCodeInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::executionRoleArn)).setter(UpdateCanaryRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> RUNTIME_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeVersion").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::runtimeVersion)).setter(UpdateCanaryRequest.setter(Builder::runtimeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersion").build()}).build();
    private static final SdkField<CanaryScheduleInput> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::schedule)).setter(UpdateCanaryRequest.setter(Builder::schedule)).constructor(CanaryScheduleInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<CanaryRunConfigInput> RUN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RunConfig").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::runConfig)).setter(UpdateCanaryRequest.setter(Builder::runConfig)).constructor(CanaryRunConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfig").build()}).build();
    private static final SdkField<Integer> SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SuccessRetentionPeriodInDays").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::successRetentionPeriodInDays)).setter(UpdateCanaryRequest.setter(Builder::successRetentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessRetentionPeriodInDays").build()}).build();
    private static final SdkField<Integer> FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailureRetentionPeriodInDays").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::failureRetentionPeriodInDays)).setter(UpdateCanaryRequest.setter(Builder::failureRetentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureRetentionPeriodInDays").build()}).build();
    private static final SdkField<VpcConfigInput> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::vpcConfig)).setter(UpdateCanaryRequest.setter(Builder::vpcConfig)).constructor(VpcConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<VisualReferenceInput> VISUAL_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualReference").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::visualReference)).setter(UpdateCanaryRequest.setter(Builder::visualReference)).constructor(VisualReferenceInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualReference").build()}).build();
    private static final SdkField<String> ARTIFACT_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactS3Location").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::artifactS3Location)).setter(UpdateCanaryRequest.setter(Builder::artifactS3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactS3Location").build()}).build();
    private static final SdkField<ArtifactConfigInput> ARTIFACT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArtifactConfig").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::artifactConfig)).setter(UpdateCanaryRequest.setter(Builder::artifactConfig)).constructor(ArtifactConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactConfig").build()}).build();
    private static final SdkField<String> PROVISIONED_RESOURCE_CLEANUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedResourceCleanup").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::provisionedResourceCleanupAsString)).setter(UpdateCanaryRequest.setter(Builder::provisionedResourceCleanup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedResourceCleanup").build()}).build();
    private static final SdkField<String> DRY_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DryRunId").getter(UpdateCanaryRequest.getter(UpdateCanaryRequest::dryRunId)).setter(UpdateCanaryRequest.setter(Builder::dryRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CODE_FIELD, EXECUTION_ROLE_ARN_FIELD, RUNTIME_VERSION_FIELD, SCHEDULE_FIELD, RUN_CONFIG_FIELD, SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD, FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD, VPC_CONFIG_FIELD, VISUAL_REFERENCE_FIELD, ARTIFACT_S3_LOCATION_FIELD, ARTIFACT_CONFIG_FIELD, PROVISIONED_RESOURCE_CLEANUP_FIELD, DRY_RUN_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCanaryRequest.memberNameToFieldInitializer();
    private final String name;
    private final CanaryCodeInput code;
    private final String executionRoleArn;
    private final String runtimeVersion;
    private final CanaryScheduleInput schedule;
    private final CanaryRunConfigInput runConfig;
    private final Integer successRetentionPeriodInDays;
    private final Integer failureRetentionPeriodInDays;
    private final VpcConfigInput vpcConfig;
    private final VisualReferenceInput visualReference;
    private final String artifactS3Location;
    private final ArtifactConfigInput artifactConfig;
    private final String provisionedResourceCleanup;
    private final String dryRunId;

    private UpdateCanaryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.code = builder.code;
        this.executionRoleArn = builder.executionRoleArn;
        this.runtimeVersion = builder.runtimeVersion;
        this.schedule = builder.schedule;
        this.runConfig = builder.runConfig;
        this.successRetentionPeriodInDays = builder.successRetentionPeriodInDays;
        this.failureRetentionPeriodInDays = builder.failureRetentionPeriodInDays;
        this.vpcConfig = builder.vpcConfig;
        this.visualReference = builder.visualReference;
        this.artifactS3Location = builder.artifactS3Location;
        this.artifactConfig = builder.artifactConfig;
        this.provisionedResourceCleanup = builder.provisionedResourceCleanup;
        this.dryRunId = builder.dryRunId;
    }

    public final String name() {
        return this.name;
    }

    public final CanaryCodeInput code() {
        return this.code;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String runtimeVersion() {
        return this.runtimeVersion;
    }

    public final CanaryScheduleInput schedule() {
        return this.schedule;
    }

    public final CanaryRunConfigInput runConfig() {
        return this.runConfig;
    }

    public final Integer successRetentionPeriodInDays() {
        return this.successRetentionPeriodInDays;
    }

    public final Integer failureRetentionPeriodInDays() {
        return this.failureRetentionPeriodInDays;
    }

    public final VpcConfigInput vpcConfig() {
        return this.vpcConfig;
    }

    public final VisualReferenceInput visualReference() {
        return this.visualReference;
    }

    public final String artifactS3Location() {
        return this.artifactS3Location;
    }

    public final ArtifactConfigInput artifactConfig() {
        return this.artifactConfig;
    }

    public final ProvisionedResourceCleanupSetting provisionedResourceCleanup() {
        return ProvisionedResourceCleanupSetting.fromValue(this.provisionedResourceCleanup);
    }

    public final String provisionedResourceCleanupAsString() {
        return this.provisionedResourceCleanup;
    }

    public final String dryRunId() {
        return this.dryRunId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.runConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.successRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedResourceCleanupAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRunId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCanaryRequest)) {
            return false;
        }
        UpdateCanaryRequest other = (UpdateCanaryRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.runtimeVersion(), other.runtimeVersion()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.runConfig(), other.runConfig()) && Objects.equals(this.successRetentionPeriodInDays(), other.successRetentionPeriodInDays()) && Objects.equals(this.failureRetentionPeriodInDays(), other.failureRetentionPeriodInDays()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.visualReference(), other.visualReference()) && Objects.equals(this.artifactS3Location(), other.artifactS3Location()) && Objects.equals(this.artifactConfig(), other.artifactConfig()) && Objects.equals(this.provisionedResourceCleanupAsString(), other.provisionedResourceCleanupAsString()) && Objects.equals(this.dryRunId(), other.dryRunId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCanaryRequest").add("Name", (Object)this.name()).add("Code", (Object)this.code()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("RuntimeVersion", (Object)this.runtimeVersion()).add("Schedule", (Object)this.schedule()).add("RunConfig", (Object)this.runConfig()).add("SuccessRetentionPeriodInDays", (Object)this.successRetentionPeriodInDays()).add("FailureRetentionPeriodInDays", (Object)this.failureRetentionPeriodInDays()).add("VpcConfig", (Object)this.vpcConfig()).add("VisualReference", (Object)this.visualReference()).add("ArtifactS3Location", (Object)this.artifactS3Location()).add("ArtifactConfig", (Object)this.artifactConfig()).add("ProvisionedResourceCleanup", (Object)this.provisionedResourceCleanupAsString()).add("DryRunId", (Object)this.dryRunId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "RuntimeVersion": {
                return Optional.ofNullable(clazz.cast(this.runtimeVersion()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "RunConfig": {
                return Optional.ofNullable(clazz.cast(this.runConfig()));
            }
            case "SuccessRetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.successRetentionPeriodInDays()));
            }
            case "FailureRetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.failureRetentionPeriodInDays()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "VisualReference": {
                return Optional.ofNullable(clazz.cast(this.visualReference()));
            }
            case "ArtifactS3Location": {
                return Optional.ofNullable(clazz.cast(this.artifactS3Location()));
            }
            case "ArtifactConfig": {
                return Optional.ofNullable(clazz.cast(this.artifactConfig()));
            }
            case "ProvisionedResourceCleanup": {
                return Optional.ofNullable(clazz.cast(this.provisionedResourceCleanupAsString()));
            }
            case "DryRunId": {
                return Optional.ofNullable(clazz.cast(this.dryRunId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("Code", CODE_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("RuntimeVersion", RUNTIME_VERSION_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("RunConfig", RUN_CONFIG_FIELD);
        map.put("SuccessRetentionPeriodInDays", SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD);
        map.put("FailureRetentionPeriodInDays", FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("VisualReference", VISUAL_REFERENCE_FIELD);
        map.put("ArtifactS3Location", ARTIFACT_S3_LOCATION_FIELD);
        map.put("ArtifactConfig", ARTIFACT_CONFIG_FIELD);
        map.put("ProvisionedResourceCleanup", PROVISIONED_RESOURCE_CLEANUP_FIELD);
        map.put("DryRunId", DRY_RUN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCanaryRequest, T> g) {
        return obj -> g.apply((UpdateCanaryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SyntheticsRequest.BuilderImpl
    implements Builder {
        private String name;
        private CanaryCodeInput code;
        private String executionRoleArn;
        private String runtimeVersion;
        private CanaryScheduleInput schedule;
        private CanaryRunConfigInput runConfig;
        private Integer successRetentionPeriodInDays;
        private Integer failureRetentionPeriodInDays;
        private VpcConfigInput vpcConfig;
        private VisualReferenceInput visualReference;
        private String artifactS3Location;
        private ArtifactConfigInput artifactConfig;
        private String provisionedResourceCleanup;
        private String dryRunId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCanaryRequest model) {
            super(model);
            this.name(model.name);
            this.code(model.code);
            this.executionRoleArn(model.executionRoleArn);
            this.runtimeVersion(model.runtimeVersion);
            this.schedule(model.schedule);
            this.runConfig(model.runConfig);
            this.successRetentionPeriodInDays(model.successRetentionPeriodInDays);
            this.failureRetentionPeriodInDays(model.failureRetentionPeriodInDays);
            this.vpcConfig(model.vpcConfig);
            this.visualReference(model.visualReference);
            this.artifactS3Location(model.artifactS3Location);
            this.artifactConfig(model.artifactConfig);
            this.provisionedResourceCleanup(model.provisionedResourceCleanup);
            this.dryRunId(model.dryRunId);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CanaryCodeInput.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        public final void setCode(CanaryCodeInput.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(CanaryCodeInput code) {
            this.code = code;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        public final void setRuntimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        @Override
        public final Builder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
            return this;
        }

        public final CanaryScheduleInput.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(CanaryScheduleInput.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(CanaryScheduleInput schedule) {
            this.schedule = schedule;
            return this;
        }

        public final CanaryRunConfigInput.Builder getRunConfig() {
            return this.runConfig != null ? this.runConfig.toBuilder() : null;
        }

        public final void setRunConfig(CanaryRunConfigInput.BuilderImpl runConfig) {
            this.runConfig = runConfig != null ? runConfig.build() : null;
        }

        @Override
        public final Builder runConfig(CanaryRunConfigInput runConfig) {
            this.runConfig = runConfig;
            return this;
        }

        public final Integer getSuccessRetentionPeriodInDays() {
            return this.successRetentionPeriodInDays;
        }

        public final void setSuccessRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
        }

        @Override
        public final Builder successRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
            return this;
        }

        public final Integer getFailureRetentionPeriodInDays() {
            return this.failureRetentionPeriodInDays;
        }

        public final void setFailureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
        }

        @Override
        public final Builder failureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
            return this;
        }

        public final VpcConfigInput.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfigInput.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfigInput vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final VisualReferenceInput.Builder getVisualReference() {
            return this.visualReference != null ? this.visualReference.toBuilder() : null;
        }

        public final void setVisualReference(VisualReferenceInput.BuilderImpl visualReference) {
            this.visualReference = visualReference != null ? visualReference.build() : null;
        }

        @Override
        public final Builder visualReference(VisualReferenceInput visualReference) {
            this.visualReference = visualReference;
            return this;
        }

        public final String getArtifactS3Location() {
            return this.artifactS3Location;
        }

        public final void setArtifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
        }

        @Override
        public final Builder artifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
            return this;
        }

        public final ArtifactConfigInput.Builder getArtifactConfig() {
            return this.artifactConfig != null ? this.artifactConfig.toBuilder() : null;
        }

        public final void setArtifactConfig(ArtifactConfigInput.BuilderImpl artifactConfig) {
            this.artifactConfig = artifactConfig != null ? artifactConfig.build() : null;
        }

        @Override
        public final Builder artifactConfig(ArtifactConfigInput artifactConfig) {
            this.artifactConfig = artifactConfig;
            return this;
        }

        public final String getProvisionedResourceCleanup() {
            return this.provisionedResourceCleanup;
        }

        public final void setProvisionedResourceCleanup(String provisionedResourceCleanup) {
            this.provisionedResourceCleanup = provisionedResourceCleanup;
        }

        @Override
        public final Builder provisionedResourceCleanup(String provisionedResourceCleanup) {
            this.provisionedResourceCleanup = provisionedResourceCleanup;
            return this;
        }

        @Override
        public final Builder provisionedResourceCleanup(ProvisionedResourceCleanupSetting provisionedResourceCleanup) {
            this.provisionedResourceCleanup(provisionedResourceCleanup == null ? null : provisionedResourceCleanup.toString());
            return this;
        }

        public final String getDryRunId() {
            return this.dryRunId;
        }

        public final void setDryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
        }

        @Override
        public final Builder dryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCanaryRequest build() {
            return new UpdateCanaryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SyntheticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCanaryRequest> {
        public Builder name(String var1);

        public Builder code(CanaryCodeInput var1);

        default public Builder code(Consumer<CanaryCodeInput.Builder> code) {
            return this.code((CanaryCodeInput)((CanaryCodeInput.Builder)CanaryCodeInput.builder().applyMutation(code)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder runtimeVersion(String var1);

        public Builder schedule(CanaryScheduleInput var1);

        default public Builder schedule(Consumer<CanaryScheduleInput.Builder> schedule) {
            return this.schedule((CanaryScheduleInput)((CanaryScheduleInput.Builder)CanaryScheduleInput.builder().applyMutation(schedule)).build());
        }

        public Builder runConfig(CanaryRunConfigInput var1);

        default public Builder runConfig(Consumer<CanaryRunConfigInput.Builder> runConfig) {
            return this.runConfig((CanaryRunConfigInput)((CanaryRunConfigInput.Builder)CanaryRunConfigInput.builder().applyMutation(runConfig)).build());
        }

        public Builder successRetentionPeriodInDays(Integer var1);

        public Builder failureRetentionPeriodInDays(Integer var1);

        public Builder vpcConfig(VpcConfigInput var1);

        default public Builder vpcConfig(Consumer<VpcConfigInput.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfigInput)((VpcConfigInput.Builder)VpcConfigInput.builder().applyMutation(vpcConfig)).build());
        }

        public Builder visualReference(VisualReferenceInput var1);

        default public Builder visualReference(Consumer<VisualReferenceInput.Builder> visualReference) {
            return this.visualReference((VisualReferenceInput)((VisualReferenceInput.Builder)VisualReferenceInput.builder().applyMutation(visualReference)).build());
        }

        public Builder artifactS3Location(String var1);

        public Builder artifactConfig(ArtifactConfigInput var1);

        default public Builder artifactConfig(Consumer<ArtifactConfigInput.Builder> artifactConfig) {
            return this.artifactConfig((ArtifactConfigInput)((ArtifactConfigInput.Builder)ArtifactConfigInput.builder().applyMutation(artifactConfig)).build());
        }

        public Builder provisionedResourceCleanup(String var1);

        public Builder provisionedResourceCleanup(ProvisionedResourceCleanupSetting var1);

        public Builder dryRunId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

