/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.synthetics.model.RuntimeVersion;

final class RuntimeVersionListCopier {
    RuntimeVersionListCopier() {
    }

    static List<RuntimeVersion> copy(Collection<? extends RuntimeVersion> runtimeVersionListParam) {
        Object list;
        if (runtimeVersionListParam == null || runtimeVersionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(runtimeVersionListParam.size());
            runtimeVersionListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RuntimeVersion> copyFromBuilder(Collection<? extends RuntimeVersion.Builder> runtimeVersionListParam) {
        Object list;
        if (runtimeVersionListParam == null || runtimeVersionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(runtimeVersionListParam.size());
            runtimeVersionListParam.forEach(entry -> {
                RuntimeVersion member = entry == null ? null : (RuntimeVersion)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RuntimeVersion.Builder> copyToBuilder(Collection<? extends RuntimeVersion> runtimeVersionListParam) {
        Object list;
        if (runtimeVersionListParam == null || runtimeVersionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(runtimeVersionListParam.size());
            runtimeVersionListParam.forEach(entry -> {
                RuntimeVersion.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

