/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.synthetics.model.BaseScreenshot;
import software.amazon.awssdk.services.synthetics.model.BaseScreenshotsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VisualReferenceOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VisualReferenceOutput> {
    private static final SdkField<List<BaseScreenshot>> BASE_SCREENSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BaseScreenshots").getter(VisualReferenceOutput.getter(VisualReferenceOutput::baseScreenshots)).setter(VisualReferenceOutput.setter(Builder::baseScreenshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseScreenshots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BaseScreenshot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BASE_CANARY_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseCanaryRunId").getter(VisualReferenceOutput.getter(VisualReferenceOutput::baseCanaryRunId)).setter(VisualReferenceOutput.setter(Builder::baseCanaryRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseCanaryRunId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_SCREENSHOTS_FIELD, BASE_CANARY_RUN_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<BaseScreenshot> baseScreenshots;
    private final String baseCanaryRunId;

    private VisualReferenceOutput(BuilderImpl builder) {
        this.baseScreenshots = builder.baseScreenshots;
        this.baseCanaryRunId = builder.baseCanaryRunId;
    }

    public final boolean hasBaseScreenshots() {
        return this.baseScreenshots != null && !(this.baseScreenshots instanceof SdkAutoConstructList);
    }

    public final List<BaseScreenshot> baseScreenshots() {
        return this.baseScreenshots;
    }

    public final String baseCanaryRunId() {
        return this.baseCanaryRunId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBaseScreenshots() ? this.baseScreenshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.baseCanaryRunId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualReferenceOutput)) {
            return false;
        }
        VisualReferenceOutput other = (VisualReferenceOutput)obj;
        return this.hasBaseScreenshots() == other.hasBaseScreenshots() && Objects.equals(this.baseScreenshots(), other.baseScreenshots()) && Objects.equals(this.baseCanaryRunId(), other.baseCanaryRunId());
    }

    public final String toString() {
        return ToString.builder((String)"VisualReferenceOutput").add("BaseScreenshots", this.hasBaseScreenshots() ? this.baseScreenshots() : null).add("BaseCanaryRunId", (Object)this.baseCanaryRunId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseScreenshots": {
                return Optional.ofNullable(clazz.cast(this.baseScreenshots()));
            }
            case "BaseCanaryRunId": {
                return Optional.ofNullable(clazz.cast(this.baseCanaryRunId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VisualReferenceOutput, T> g) {
        return obj -> g.apply((VisualReferenceOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<BaseScreenshot> baseScreenshots = DefaultSdkAutoConstructList.getInstance();
        private String baseCanaryRunId;

        private BuilderImpl() {
        }

        private BuilderImpl(VisualReferenceOutput model) {
            this.baseScreenshots(model.baseScreenshots);
            this.baseCanaryRunId(model.baseCanaryRunId);
        }

        public final List<BaseScreenshot.Builder> getBaseScreenshots() {
            List<BaseScreenshot.Builder> result = BaseScreenshotsCopier.copyToBuilder(this.baseScreenshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBaseScreenshots(Collection<BaseScreenshot.BuilderImpl> baseScreenshots) {
            this.baseScreenshots = BaseScreenshotsCopier.copyFromBuilder(baseScreenshots);
        }

        @Override
        @Transient
        public final Builder baseScreenshots(Collection<BaseScreenshot> baseScreenshots) {
            this.baseScreenshots = BaseScreenshotsCopier.copy(baseScreenshots);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder baseScreenshots(BaseScreenshot ... baseScreenshots) {
            this.baseScreenshots(Arrays.asList(baseScreenshots));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder baseScreenshots(Consumer<BaseScreenshot.Builder> ... baseScreenshots) {
            this.baseScreenshots(Stream.of(baseScreenshots).map(c -> (BaseScreenshot)((BaseScreenshot.Builder)BaseScreenshot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBaseCanaryRunId() {
            return this.baseCanaryRunId;
        }

        public final void setBaseCanaryRunId(String baseCanaryRunId) {
            this.baseCanaryRunId = baseCanaryRunId;
        }

        @Override
        @Transient
        public final Builder baseCanaryRunId(String baseCanaryRunId) {
            this.baseCanaryRunId = baseCanaryRunId;
            return this;
        }

        public VisualReferenceOutput build() {
            return new VisualReferenceOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VisualReferenceOutput> {
        public Builder baseScreenshots(Collection<BaseScreenshot> var1);

        public Builder baseScreenshots(BaseScreenshot ... var1);

        public Builder baseScreenshots(Consumer<BaseScreenshot.Builder> ... var1);

        public Builder baseCanaryRunId(String var1);
    }
}

