/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuntimeVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuntimeVersion> {
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionName").getter(RuntimeVersion.getter(RuntimeVersion::versionName)).setter(RuntimeVersion.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RuntimeVersion.getter(RuntimeVersion::description)).setter(RuntimeVersion.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> RELEASE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReleaseDate").getter(RuntimeVersion.getter(RuntimeVersion::releaseDate)).setter(RuntimeVersion.setter(Builder::releaseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseDate").build()}).build();
    private static final SdkField<Instant> DEPRECATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeprecationDate").getter(RuntimeVersion.getter(RuntimeVersion::deprecationDate)).setter(RuntimeVersion.setter(Builder::deprecationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_NAME_FIELD, DESCRIPTION_FIELD, RELEASE_DATE_FIELD, DEPRECATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String versionName;
    private final String description;
    private final Instant releaseDate;
    private final Instant deprecationDate;

    private RuntimeVersion(BuilderImpl builder) {
        this.versionName = builder.versionName;
        this.description = builder.description;
        this.releaseDate = builder.releaseDate;
        this.deprecationDate = builder.deprecationDate;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String description() {
        return this.description;
    }

    public final Instant releaseDate() {
        return this.releaseDate;
    }

    public final Instant deprecationDate() {
        return this.deprecationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeVersion)) {
            return false;
        }
        RuntimeVersion other = (RuntimeVersion)obj;
        return Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.releaseDate(), other.releaseDate()) && Objects.equals(this.deprecationDate(), other.deprecationDate());
    }

    public final String toString() {
        return ToString.builder((String)"RuntimeVersion").add("VersionName", (Object)this.versionName()).add("Description", (Object)this.description()).add("ReleaseDate", (Object)this.releaseDate()).add("DeprecationDate", (Object)this.deprecationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VersionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ReleaseDate": {
                return Optional.ofNullable(clazz.cast(this.releaseDate()));
            }
            case "DeprecationDate": {
                return Optional.ofNullable(clazz.cast(this.deprecationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimeVersion, T> g) {
        return obj -> g.apply((RuntimeVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String versionName;
        private String description;
        private Instant releaseDate;
        private Instant deprecationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeVersion model) {
            this.versionName(model.versionName);
            this.description(model.description);
            this.releaseDate(model.releaseDate);
            this.deprecationDate(model.deprecationDate);
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        @Transient
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getReleaseDate() {
            return this.releaseDate;
        }

        public final void setReleaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
        }

        @Override
        @Transient
        public final Builder releaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final Instant getDeprecationDate() {
            return this.deprecationDate;
        }

        public final void setDeprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
        }

        @Override
        @Transient
        public final Builder deprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
            return this;
        }

        public RuntimeVersion build() {
            return new RuntimeVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuntimeVersion> {
        public Builder versionName(String var1);

        public Builder description(String var1);

        public Builder releaseDate(Instant var1);

        public Builder deprecationDate(Instant var1);
    }
}

