/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanaryScheduleOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanaryScheduleOutput> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expression").getter(CanaryScheduleOutput.getter(CanaryScheduleOutput::expression)).setter(CanaryScheduleOutput.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<Long> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationInSeconds").getter(CanaryScheduleOutput.getter(CanaryScheduleOutput::durationInSeconds)).setter(CanaryScheduleOutput.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, DURATION_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final Long durationInSeconds;

    private CanaryScheduleOutput(BuilderImpl builder) {
        this.expression = builder.expression;
        this.durationInSeconds = builder.durationInSeconds;
    }

    public String expression() {
        return this.expression;
    }

    public Long durationInSeconds() {
        return this.durationInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryScheduleOutput)) {
            return false;
        }
        CanaryScheduleOutput other = (CanaryScheduleOutput)obj;
        return Objects.equals(this.expression(), other.expression()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"CanaryScheduleOutput").add("Expression", (Object)this.expression()).add("DurationInSeconds", (Object)this.durationInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "DurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryScheduleOutput, T> g) {
        return obj -> g.apply((CanaryScheduleOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expression;
        private Long durationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryScheduleOutput model) {
            this.expression(model.expression);
            this.durationInSeconds(model.durationInSeconds);
        }

        public final String getExpression() {
            return this.expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        public final Long getDurationInSeconds() {
            return this.durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        public CanaryScheduleOutput build() {
            return new CanaryScheduleOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanaryScheduleOutput> {
        public Builder expression(String var1);

        public Builder durationInSeconds(Long var1);
    }
}

