/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowExecutionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowExecutionConfiguration> {
    private static final SdkField<String> TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskStartToCloseTimeout").getter(WorkflowExecutionConfiguration.getter(WorkflowExecutionConfiguration::taskStartToCloseTimeout)).setter(WorkflowExecutionConfiguration.setter(Builder::taskStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartToCloseTimeout").build()}).build();
    private static final SdkField<String> EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionStartToCloseTimeout").getter(WorkflowExecutionConfiguration.getter(WorkflowExecutionConfiguration::executionStartToCloseTimeout)).setter(WorkflowExecutionConfiguration.setter(Builder::executionStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartToCloseTimeout").build()}).build();
    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taskList").getter(WorkflowExecutionConfiguration.getter(WorkflowExecutionConfiguration::taskList)).setter(WorkflowExecutionConfiguration.setter(Builder::taskList)).constructor(TaskList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()}).build();
    private static final SdkField<String> TASK_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskPriority").getter(WorkflowExecutionConfiguration.getter(WorkflowExecutionConfiguration::taskPriority)).setter(WorkflowExecutionConfiguration.setter(Builder::taskPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskPriority").build()}).build();
    private static final SdkField<String> CHILD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("childPolicy").getter(WorkflowExecutionConfiguration.getter(WorkflowExecutionConfiguration::childPolicyAsString)).setter(WorkflowExecutionConfiguration.setter(Builder::childPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childPolicy").build()}).build();
    private static final SdkField<String> LAMBDA_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambdaRole").getter(WorkflowExecutionConfiguration.getter(WorkflowExecutionConfiguration::lambdaRole)).setter(WorkflowExecutionConfiguration.setter(Builder::lambdaRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_START_TO_CLOSE_TIMEOUT_FIELD, EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD, TASK_LIST_FIELD, TASK_PRIORITY_FIELD, CHILD_POLICY_FIELD, LAMBDA_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkflowExecutionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String taskStartToCloseTimeout;
    private final String executionStartToCloseTimeout;
    private final TaskList taskList;
    private final String taskPriority;
    private final String childPolicy;
    private final String lambdaRole;

    private WorkflowExecutionConfiguration(BuilderImpl builder) {
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.childPolicy = builder.childPolicy;
        this.lambdaRole = builder.lambdaRole;
    }

    public final String taskStartToCloseTimeout() {
        return this.taskStartToCloseTimeout;
    }

    public final String executionStartToCloseTimeout() {
        return this.executionStartToCloseTimeout;
    }

    public final TaskList taskList() {
        return this.taskList;
    }

    public final String taskPriority() {
        return this.taskPriority;
    }

    public final ChildPolicy childPolicy() {
        return ChildPolicy.fromValue(this.childPolicy);
    }

    public final String childPolicyAsString() {
        return this.childPolicy;
    }

    public final String lambdaRole() {
        return this.lambdaRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskList());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.childPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionConfiguration)) {
            return false;
        }
        WorkflowExecutionConfiguration other = (WorkflowExecutionConfiguration)obj;
        return Objects.equals(this.taskStartToCloseTimeout(), other.taskStartToCloseTimeout()) && Objects.equals(this.executionStartToCloseTimeout(), other.executionStartToCloseTimeout()) && Objects.equals(this.taskList(), other.taskList()) && Objects.equals(this.taskPriority(), other.taskPriority()) && Objects.equals(this.childPolicyAsString(), other.childPolicyAsString()) && Objects.equals(this.lambdaRole(), other.lambdaRole());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowExecutionConfiguration").add("TaskStartToCloseTimeout", (Object)this.taskStartToCloseTimeout()).add("ExecutionStartToCloseTimeout", (Object)this.executionStartToCloseTimeout()).add("TaskList", (Object)this.taskList()).add("TaskPriority", (Object)this.taskPriority()).add("ChildPolicy", (Object)this.childPolicyAsString()).add("LambdaRole", (Object)this.lambdaRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.taskStartToCloseTimeout()));
            }
            case "executionStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.executionStartToCloseTimeout()));
            }
            case "taskList": {
                return Optional.ofNullable(clazz.cast(this.taskList()));
            }
            case "taskPriority": {
                return Optional.ofNullable(clazz.cast(this.taskPriority()));
            }
            case "childPolicy": {
                return Optional.ofNullable(clazz.cast(this.childPolicyAsString()));
            }
            case "lambdaRole": {
                return Optional.ofNullable(clazz.cast(this.lambdaRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskStartToCloseTimeout", TASK_START_TO_CLOSE_TIMEOUT_FIELD);
        map.put("executionStartToCloseTimeout", EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD);
        map.put("taskList", TASK_LIST_FIELD);
        map.put("taskPriority", TASK_PRIORITY_FIELD);
        map.put("childPolicy", CHILD_POLICY_FIELD);
        map.put("lambdaRole", LAMBDA_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionConfiguration, T> g) {
        return obj -> g.apply((WorkflowExecutionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskStartToCloseTimeout;
        private String executionStartToCloseTimeout;
        private TaskList taskList;
        private String taskPriority;
        private String childPolicy;
        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionConfiguration model) {
            this.taskStartToCloseTimeout(model.taskStartToCloseTimeout);
            this.executionStartToCloseTimeout(model.executionStartToCloseTimeout);
            this.taskList(model.taskList);
            this.taskPriority(model.taskPriority);
            this.childPolicy(model.childPolicy);
            this.lambdaRole(model.lambdaRole);
        }

        public final String getTaskStartToCloseTimeout() {
            return this.taskStartToCloseTimeout;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final String getExecutionStartToCloseTimeout() {
            return this.executionStartToCloseTimeout;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final TaskList.Builder getTaskList() {
            return this.taskList != null ? this.taskList.toBuilder() : null;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final String getTaskPriority() {
            return this.taskPriority;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final String getChildPolicy() {
            return this.childPolicy;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy == null ? null : childPolicy.toString());
            return this;
        }

        public final String getLambdaRole() {
            return this.lambdaRole;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public WorkflowExecutionConfiguration build() {
            return new WorkflowExecutionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowExecutionConfiguration> {
        public Builder taskStartToCloseTimeout(String var1);

        public Builder executionStartToCloseTimeout(String var1);

        public Builder taskList(TaskList var1);

        default public Builder taskList(Consumer<TaskList.Builder> taskList) {
            return this.taskList((TaskList)((TaskList.Builder)TaskList.builder().applyMutation(taskList)).build());
        }

        public Builder taskPriority(String var1);

        public Builder childPolicy(String var1);

        public Builder childPolicy(ChildPolicy var1);

        public Builder lambdaRole(String var1);
    }
}

