/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>MarkerRecorded</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MarkerRecordedEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<MarkerRecordedEventAttributes.Builder, MarkerRecordedEventAttributes> {
    private static final SdkField<String> MARKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("markerName").getter(getter(MarkerRecordedEventAttributes::markerName))
            .setter(setter(Builder::markerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("markerName").build()).build();

    private static final SdkField<String> DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("details")
            .getter(getter(MarkerRecordedEventAttributes::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("decisionTaskCompletedEventId")
            .getter(getter(MarkerRecordedEventAttributes::decisionTaskCompletedEventId))
            .setter(setter(Builder::decisionTaskCompletedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_NAME_FIELD,
            DETAILS_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String markerName;

    private final String details;

    private final Long decisionTaskCompletedEventId;

    private MarkerRecordedEventAttributes(BuilderImpl builder) {
        this.markerName = builder.markerName;
        this.details = builder.details;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The name of the marker.
     * </p>
     * 
     * @return The name of the marker.
     */
    public final String markerName() {
        return markerName;
    }

    /**
     * <p>
     * The details of the marker.
     * </p>
     * 
     * @return The details of the marker.
     */
    public final String details() {
        return details;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>RecordMarker</code> decision that requested this marker. This information can be useful for diagnosing
     * problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>RecordMarker</code> decision that requested this marker. This information can be useful for
     *         diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public final Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(markerName());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MarkerRecordedEventAttributes)) {
            return false;
        }
        MarkerRecordedEventAttributes other = (MarkerRecordedEventAttributes) obj;
        return Objects.equals(markerName(), other.markerName()) && Objects.equals(details(), other.details())
                && Objects.equals(decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MarkerRecordedEventAttributes").add("MarkerName", markerName()).add("Details", details())
                .add("DecisionTaskCompletedEventId", decisionTaskCompletedEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "markerName":
            return Optional.ofNullable(clazz.cast(markerName()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "decisionTaskCompletedEventId":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("markerName", MARKER_NAME_FIELD);
        map.put("details", DETAILS_FIELD);
        map.put("decisionTaskCompletedEventId", DECISION_TASK_COMPLETED_EVENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MarkerRecordedEventAttributes, T> g) {
        return obj -> g.apply((MarkerRecordedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MarkerRecordedEventAttributes> {
        /**
         * <p>
         * The name of the marker.
         * </p>
         * 
         * @param markerName
         *        The name of the marker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder markerName(String markerName);

        /**
         * <p>
         * The details of the marker.
         * </p>
         * 
         * @param details
         *        The details of the marker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>RecordMarker</code> decision that requested this marker. This information can be useful for
         * diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>RecordMarker</code> decision that requested this marker. This information can be
         *        useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);
    }

    static final class BuilderImpl implements Builder {
        private String markerName;

        private String details;

        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(MarkerRecordedEventAttributes model) {
            markerName(model.markerName);
            details(model.details);
            decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final String getMarkerName() {
            return markerName;
        }

        public final void setMarkerName(String markerName) {
            this.markerName = markerName;
        }

        @Override
        public final Builder markerName(String markerName) {
            this.markerName = markerName;
            return this;
        }

        public final String getDetails() {
            return details;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        @Override
        public MarkerRecordedEventAttributes build() {
            return new MarkerRecordedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
