/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.CloseStatusFilter;
import software.amazon.awssdk.services.swf.model.ExecutionTimeFilter;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.services.swf.model.TagFilter;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionFilter;
import software.amazon.awssdk.services.swf.model.WorkflowTypeFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CountClosedWorkflowExecutionsRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, CountClosedWorkflowExecutionsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(CountClosedWorkflowExecutionsRequest.getter(CountClosedWorkflowExecutionsRequest::domain)).setter(CountClosedWorkflowExecutionsRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<ExecutionTimeFilter> START_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("startTimeFilter").getter(CountClosedWorkflowExecutionsRequest.getter(CountClosedWorkflowExecutionsRequest::startTimeFilter)).setter(CountClosedWorkflowExecutionsRequest.setter(Builder::startTimeFilter)).constructor(ExecutionTimeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeFilter").build()}).build();
    private static final SdkField<ExecutionTimeFilter> CLOSE_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("closeTimeFilter").getter(CountClosedWorkflowExecutionsRequest.getter(CountClosedWorkflowExecutionsRequest::closeTimeFilter)).setter(CountClosedWorkflowExecutionsRequest.setter(Builder::closeTimeFilter)).constructor(ExecutionTimeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closeTimeFilter").build()}).build();
    private static final SdkField<WorkflowExecutionFilter> EXECUTION_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionFilter").getter(CountClosedWorkflowExecutionsRequest.getter(CountClosedWorkflowExecutionsRequest::executionFilter)).setter(CountClosedWorkflowExecutionsRequest.setter(Builder::executionFilter)).constructor(WorkflowExecutionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionFilter").build()}).build();
    private static final SdkField<WorkflowTypeFilter> TYPE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("typeFilter").getter(CountClosedWorkflowExecutionsRequest.getter(CountClosedWorkflowExecutionsRequest::typeFilter)).setter(CountClosedWorkflowExecutionsRequest.setter(Builder::typeFilter)).constructor(WorkflowTypeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeFilter").build()}).build();
    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tagFilter").getter(CountClosedWorkflowExecutionsRequest.getter(CountClosedWorkflowExecutionsRequest::tagFilter)).setter(CountClosedWorkflowExecutionsRequest.setter(Builder::tagFilter)).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()}).build();
    private static final SdkField<CloseStatusFilter> CLOSE_STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("closeStatusFilter").getter(CountClosedWorkflowExecutionsRequest.getter(CountClosedWorkflowExecutionsRequest::closeStatusFilter)).setter(CountClosedWorkflowExecutionsRequest.setter(Builder::closeStatusFilter)).constructor(CloseStatusFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closeStatusFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, START_TIME_FILTER_FIELD, CLOSE_TIME_FILTER_FIELD, EXECUTION_FILTER_FIELD, TYPE_FILTER_FIELD, TAG_FILTER_FIELD, CLOSE_STATUS_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CountClosedWorkflowExecutionsRequest.memberNameToFieldInitializer();
    private final String domain;
    private final ExecutionTimeFilter startTimeFilter;
    private final ExecutionTimeFilter closeTimeFilter;
    private final WorkflowExecutionFilter executionFilter;
    private final WorkflowTypeFilter typeFilter;
    private final TagFilter tagFilter;
    private final CloseStatusFilter closeStatusFilter;

    private CountClosedWorkflowExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.startTimeFilter = builder.startTimeFilter;
        this.closeTimeFilter = builder.closeTimeFilter;
        this.executionFilter = builder.executionFilter;
        this.typeFilter = builder.typeFilter;
        this.tagFilter = builder.tagFilter;
        this.closeStatusFilter = builder.closeStatusFilter;
    }

    public final String domain() {
        return this.domain;
    }

    public final ExecutionTimeFilter startTimeFilter() {
        return this.startTimeFilter;
    }

    public final ExecutionTimeFilter closeTimeFilter() {
        return this.closeTimeFilter;
    }

    public final WorkflowExecutionFilter executionFilter() {
        return this.executionFilter;
    }

    public final WorkflowTypeFilter typeFilter() {
        return this.typeFilter;
    }

    public final TagFilter tagFilter() {
        return this.tagFilter;
    }

    public final CloseStatusFilter closeStatusFilter() {
        return this.closeStatusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.closeTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.closeStatusFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountClosedWorkflowExecutionsRequest)) {
            return false;
        }
        CountClosedWorkflowExecutionsRequest other = (CountClosedWorkflowExecutionsRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.startTimeFilter(), other.startTimeFilter()) && Objects.equals(this.closeTimeFilter(), other.closeTimeFilter()) && Objects.equals(this.executionFilter(), other.executionFilter()) && Objects.equals(this.typeFilter(), other.typeFilter()) && Objects.equals(this.tagFilter(), other.tagFilter()) && Objects.equals(this.closeStatusFilter(), other.closeStatusFilter());
    }

    public final String toString() {
        return ToString.builder((String)"CountClosedWorkflowExecutionsRequest").add("Domain", (Object)this.domain()).add("StartTimeFilter", (Object)this.startTimeFilter()).add("CloseTimeFilter", (Object)this.closeTimeFilter()).add("ExecutionFilter", (Object)this.executionFilter()).add("TypeFilter", (Object)this.typeFilter()).add("TagFilter", (Object)this.tagFilter()).add("CloseStatusFilter", (Object)this.closeStatusFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "startTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.startTimeFilter()));
            }
            case "closeTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.closeTimeFilter()));
            }
            case "executionFilter": {
                return Optional.ofNullable(clazz.cast(this.executionFilter()));
            }
            case "typeFilter": {
                return Optional.ofNullable(clazz.cast(this.typeFilter()));
            }
            case "tagFilter": {
                return Optional.ofNullable(clazz.cast(this.tagFilter()));
            }
            case "closeStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.closeStatusFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domain", DOMAIN_FIELD);
        map.put("startTimeFilter", START_TIME_FILTER_FIELD);
        map.put("closeTimeFilter", CLOSE_TIME_FILTER_FIELD);
        map.put("executionFilter", EXECUTION_FILTER_FIELD);
        map.put("typeFilter", TYPE_FILTER_FIELD);
        map.put("tagFilter", TAG_FILTER_FIELD);
        map.put("closeStatusFilter", CLOSE_STATUS_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CountClosedWorkflowExecutionsRequest, T> g) {
        return obj -> g.apply((CountClosedWorkflowExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private ExecutionTimeFilter startTimeFilter;
        private ExecutionTimeFilter closeTimeFilter;
        private WorkflowExecutionFilter executionFilter;
        private WorkflowTypeFilter typeFilter;
        private TagFilter tagFilter;
        private CloseStatusFilter closeStatusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(CountClosedWorkflowExecutionsRequest model) {
            super(model);
            this.domain(model.domain);
            this.startTimeFilter(model.startTimeFilter);
            this.closeTimeFilter(model.closeTimeFilter);
            this.executionFilter(model.executionFilter);
            this.typeFilter(model.typeFilter);
            this.tagFilter(model.tagFilter);
            this.closeStatusFilter(model.closeStatusFilter);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final ExecutionTimeFilter.Builder getStartTimeFilter() {
            return this.startTimeFilter != null ? this.startTimeFilter.toBuilder() : null;
        }

        public final void setStartTimeFilter(ExecutionTimeFilter.BuilderImpl startTimeFilter) {
            this.startTimeFilter = startTimeFilter != null ? startTimeFilter.build() : null;
        }

        @Override
        public final Builder startTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final ExecutionTimeFilter.Builder getCloseTimeFilter() {
            return this.closeTimeFilter != null ? this.closeTimeFilter.toBuilder() : null;
        }

        public final void setCloseTimeFilter(ExecutionTimeFilter.BuilderImpl closeTimeFilter) {
            this.closeTimeFilter = closeTimeFilter != null ? closeTimeFilter.build() : null;
        }

        @Override
        public final Builder closeTimeFilter(ExecutionTimeFilter closeTimeFilter) {
            this.closeTimeFilter = closeTimeFilter;
            return this;
        }

        public final WorkflowExecutionFilter.Builder getExecutionFilter() {
            return this.executionFilter != null ? this.executionFilter.toBuilder() : null;
        }

        public final void setExecutionFilter(WorkflowExecutionFilter.BuilderImpl executionFilter) {
            this.executionFilter = executionFilter != null ? executionFilter.build() : null;
        }

        @Override
        public final Builder executionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
            return this;
        }

        public final WorkflowTypeFilter.Builder getTypeFilter() {
            return this.typeFilter != null ? this.typeFilter.toBuilder() : null;
        }

        public final void setTypeFilter(WorkflowTypeFilter.BuilderImpl typeFilter) {
            this.typeFilter = typeFilter != null ? typeFilter.build() : null;
        }

        @Override
        public final Builder typeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public final TagFilter.Builder getTagFilter() {
            return this.tagFilter != null ? this.tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final CloseStatusFilter.Builder getCloseStatusFilter() {
            return this.closeStatusFilter != null ? this.closeStatusFilter.toBuilder() : null;
        }

        public final void setCloseStatusFilter(CloseStatusFilter.BuilderImpl closeStatusFilter) {
            this.closeStatusFilter = closeStatusFilter != null ? closeStatusFilter.build() : null;
        }

        @Override
        public final Builder closeStatusFilter(CloseStatusFilter closeStatusFilter) {
            this.closeStatusFilter = closeStatusFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CountClosedWorkflowExecutionsRequest build() {
            return new CountClosedWorkflowExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CountClosedWorkflowExecutionsRequest> {
        public Builder domain(String var1);

        public Builder startTimeFilter(ExecutionTimeFilter var1);

        default public Builder startTimeFilter(Consumer<ExecutionTimeFilter.Builder> startTimeFilter) {
            return this.startTimeFilter((ExecutionTimeFilter)((ExecutionTimeFilter.Builder)ExecutionTimeFilter.builder().applyMutation(startTimeFilter)).build());
        }

        public Builder closeTimeFilter(ExecutionTimeFilter var1);

        default public Builder closeTimeFilter(Consumer<ExecutionTimeFilter.Builder> closeTimeFilter) {
            return this.closeTimeFilter((ExecutionTimeFilter)((ExecutionTimeFilter.Builder)ExecutionTimeFilter.builder().applyMutation(closeTimeFilter)).build());
        }

        public Builder executionFilter(WorkflowExecutionFilter var1);

        default public Builder executionFilter(Consumer<WorkflowExecutionFilter.Builder> executionFilter) {
            return this.executionFilter((WorkflowExecutionFilter)((WorkflowExecutionFilter.Builder)WorkflowExecutionFilter.builder().applyMutation(executionFilter)).build());
        }

        public Builder typeFilter(WorkflowTypeFilter var1);

        default public Builder typeFilter(Consumer<WorkflowTypeFilter.Builder> typeFilter) {
            return this.typeFilter((WorkflowTypeFilter)((WorkflowTypeFilter.Builder)WorkflowTypeFilter.builder().applyMutation(typeFilter)).build());
        }

        public Builder tagFilter(TagFilter var1);

        default public Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return this.tagFilter((TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation(tagFilter)).build());
        }

        public Builder closeStatusFilter(CloseStatusFilter var1);

        default public Builder closeStatusFilter(Consumer<CloseStatusFilter.Builder> closeStatusFilter) {
            return this.closeStatusFilter((CloseStatusFilter)((CloseStatusFilter.Builder)CloseStatusFilter.builder().applyMutation(closeStatusFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

