/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.swf.DefaultSwfAsyncClient;
import software.amazon.awssdk.services.swf.DefaultSwfBaseClientBuilder;
import software.amazon.awssdk.services.swf.SwfAsyncClient;
import software.amazon.awssdk.services.swf.SwfAsyncClientBuilder;
import software.amazon.awssdk.services.swf.SwfServiceClientConfiguration;
import software.amazon.awssdk.services.swf.endpoints.SwfEndpointProvider;

@SdkInternalApi
final class DefaultSwfAsyncClientBuilder
extends DefaultSwfBaseClientBuilder<SwfAsyncClientBuilder, SwfAsyncClient>
implements SwfAsyncClientBuilder {
    DefaultSwfAsyncClientBuilder() {
    }

    @Override
    public DefaultSwfAsyncClientBuilder endpointProvider(SwfEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SwfAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSwfAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SwfServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSwfAsyncClient client = new DefaultSwfAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SwfServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SwfServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

