/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.internal.UserAgentUtils;
import software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo;

public class ListClosedWorkflowExecutionsIterable
implements SdkIterable<ListClosedWorkflowExecutionsResponse> {
    private final SwfClient client;
    private final ListClosedWorkflowExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClosedWorkflowExecutionsIterable(SwfClient client, ListClosedWorkflowExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClosedWorkflowExecutionsResponseFetcher();
    }

    public Iterator<ListClosedWorkflowExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowExecutionInfo> executionInfos() {
        Function<ListClosedWorkflowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.executionInfos() != null) {
                return response.executionInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClosedWorkflowExecutionsResponseFetcher
    implements SyncPageFetcher<ListClosedWorkflowExecutionsResponse> {
        private ListClosedWorkflowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListClosedWorkflowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListClosedWorkflowExecutionsResponse nextPage(ListClosedWorkflowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListClosedWorkflowExecutionsIterable.this.client.listClosedWorkflowExecutions(ListClosedWorkflowExecutionsIterable.this.firstRequest);
            }
            return ListClosedWorkflowExecutionsIterable.this.client.listClosedWorkflowExecutions((ListClosedWorkflowExecutionsRequest)((Object)ListClosedWorkflowExecutionsIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

