/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings registered with the activity type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivityTypeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ActivityTypeConfiguration.Builder, ActivityTypeConfiguration> {
    private static final SdkField<String> DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskStartToCloseTimeout")
            .getter(getter(ActivityTypeConfiguration::defaultTaskStartToCloseTimeout))
            .setter(setter(Builder::defaultTaskStartToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskStartToCloseTimeout")
                    .build()).build();

    private static final SdkField<String> DEFAULT_TASK_HEARTBEAT_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskHeartbeatTimeout")
            .getter(getter(ActivityTypeConfiguration::defaultTaskHeartbeatTimeout))
            .setter(setter(Builder::defaultTaskHeartbeatTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskHeartbeatTimeout")
                    .build()).build();

    private static final SdkField<TaskList> DEFAULT_TASK_LIST_FIELD = SdkField.<TaskList> builder(MarshallingType.SDK_POJO)
            .memberName("defaultTaskList").getter(getter(ActivityTypeConfiguration::defaultTaskList))
            .setter(setter(Builder::defaultTaskList)).constructor(TaskList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskList").build()).build();

    private static final SdkField<String> DEFAULT_TASK_PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskPriority").getter(getter(ActivityTypeConfiguration::defaultTaskPriority))
            .setter(setter(Builder::defaultTaskPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskPriority").build())
            .build();

    private static final SdkField<String> DEFAULT_TASK_SCHEDULE_TO_START_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskScheduleToStartTimeout")
            .getter(getter(ActivityTypeConfiguration::defaultTaskScheduleToStartTimeout))
            .setter(setter(Builder::defaultTaskScheduleToStartTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskScheduleToStartTimeout")
                    .build()).build();

    private static final SdkField<String> DEFAULT_TASK_SCHEDULE_TO_CLOSE_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskScheduleToCloseTimeout")
            .getter(getter(ActivityTypeConfiguration::defaultTaskScheduleToCloseTimeout))
            .setter(setter(Builder::defaultTaskScheduleToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskScheduleToCloseTimeout")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD, DEFAULT_TASK_HEARTBEAT_TIMEOUT_FIELD, DEFAULT_TASK_LIST_FIELD,
            DEFAULT_TASK_PRIORITY_FIELD, DEFAULT_TASK_SCHEDULE_TO_START_TIMEOUT_FIELD,
            DEFAULT_TASK_SCHEDULE_TO_CLOSE_TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultTaskStartToCloseTimeout;

    private final String defaultTaskHeartbeatTimeout;

    private final TaskList defaultTaskList;

    private final String defaultTaskPriority;

    private final String defaultTaskScheduleToStartTimeout;

    private final String defaultTaskScheduleToCloseTimeout;

    private ActivityTypeConfiguration(BuilderImpl builder) {
        this.defaultTaskStartToCloseTimeout = builder.defaultTaskStartToCloseTimeout;
        this.defaultTaskHeartbeatTimeout = builder.defaultTaskHeartbeatTimeout;
        this.defaultTaskList = builder.defaultTaskList;
        this.defaultTaskPriority = builder.defaultTaskPriority;
        this.defaultTaskScheduleToStartTimeout = builder.defaultTaskScheduleToStartTimeout;
        this.defaultTaskScheduleToCloseTimeout = builder.defaultTaskScheduleToCloseTimeout;
    }

    /**
     * <p>
     * The default maximum duration for tasks of an activity type specified when registering the activity type. You can
     * override this default when scheduling a task through the <code>ScheduleActivityTask</code> <a>Decision</a>.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return The default maximum duration for tasks of an activity type specified when registering the activity type.
     *         You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
     *         <a>Decision</a>.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public final String defaultTaskStartToCloseTimeout() {
        return defaultTaskStartToCloseTimeout;
    }

    /**
     * <p>
     * The default maximum time, in seconds, before which a worker processing a task must report progress by calling
     * <a>RecordActivityTaskHeartbeat</a>.
     * </p>
     * <p>
     * You can specify this value only when <i>registering</i> an activity type. The registered default value can be
     * overridden when you schedule a task through the <code>ScheduleActivityTask</code> <a>Decision</a>. If the
     * activity worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an
     * <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to be valid;
     * the activity worker should clean up the activity task.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return The default maximum time, in seconds, before which a worker processing a task must report progress by
     *         calling <a>RecordActivityTaskHeartbeat</a>.</p>
     *         <p>
     *         You can specify this value only when <i>registering</i> an activity type. The registered default value
     *         can be overridden when you schedule a task through the <code>ScheduleActivityTask</code> <a>Decision</a>.
     *         If the activity worker subsequently attempts to record a heartbeat or returns a result, the activity
     *         worker receives an <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the
     *         activity task to be valid; the activity worker should clean up the activity task.
     *         </p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public final String defaultTaskHeartbeatTimeout() {
        return defaultTaskHeartbeatTimeout;
    }

    /**
     * <p>
     * The default task list specified for this activity type at registration. This default is used if a task list isn't
     * provided when a task is scheduled through the <code>ScheduleActivityTask</code> <a>Decision</a>. You can override
     * the default registered task list when scheduling a task through the <code>ScheduleActivityTask</code>
     * <a>Decision</a>.
     * </p>
     * 
     * @return The default task list specified for this activity type at registration. This default is used if a task
     *         list isn't provided when a task is scheduled through the <code>ScheduleActivityTask</code>
     *         <a>Decision</a>. You can override the default registered task list when scheduling a task through the
     *         <code>ScheduleActivityTask</code> <a>Decision</a>.
     */
    public final TaskList defaultTaskList() {
        return defaultTaskList;
    }

    /**
     * <p>
     * The default task priority for tasks of this activity type, specified at registration. If not set, then
     * <code>0</code> is used as the default priority. This default can be overridden when scheduling an activity task.
     * </p>
     * <p>
     * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * 
     * @return The default task priority for tasks of this activity type, specified at registration. If not set, then
     *         <code>0</code> is used as the default priority. This default can be overridden when scheduling an
     *         activity task.</p>
     *         <p>
     *         Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     *         </p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     */
    public final String defaultTaskPriority() {
        return defaultTaskPriority;
    }

    /**
     * <p>
     * The default maximum duration, specified when registering the activity type, that a task of an activity type can
     * wait before being assigned to a worker. You can override this default when scheduling a task through the
     * <code>ScheduleActivityTask</code> <a>Decision</a>.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return The default maximum duration, specified when registering the activity type, that a task of an activity
     *         type can wait before being assigned to a worker. You can override this default when scheduling a task
     *         through the <code>ScheduleActivityTask</code> <a>Decision</a>.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public final String defaultTaskScheduleToStartTimeout() {
        return defaultTaskScheduleToStartTimeout;
    }

    /**
     * <p>
     * The default maximum duration, specified when registering the activity type, for tasks of this activity type. You
     * can override this default when scheduling a task through the <code>ScheduleActivityTask</code> <a>Decision</a>.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return The default maximum duration, specified when registering the activity type, for tasks of this activity
     *         type. You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
     *         <a>Decision</a>.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public final String defaultTaskScheduleToCloseTimeout() {
        return defaultTaskScheduleToCloseTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskHeartbeatTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskList());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskScheduleToStartTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskScheduleToCloseTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTypeConfiguration)) {
            return false;
        }
        ActivityTypeConfiguration other = (ActivityTypeConfiguration) obj;
        return Objects.equals(defaultTaskStartToCloseTimeout(), other.defaultTaskStartToCloseTimeout())
                && Objects.equals(defaultTaskHeartbeatTimeout(), other.defaultTaskHeartbeatTimeout())
                && Objects.equals(defaultTaskList(), other.defaultTaskList())
                && Objects.equals(defaultTaskPriority(), other.defaultTaskPriority())
                && Objects.equals(defaultTaskScheduleToStartTimeout(), other.defaultTaskScheduleToStartTimeout())
                && Objects.equals(defaultTaskScheduleToCloseTimeout(), other.defaultTaskScheduleToCloseTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActivityTypeConfiguration")
                .add("DefaultTaskStartToCloseTimeout", defaultTaskStartToCloseTimeout())
                .add("DefaultTaskHeartbeatTimeout", defaultTaskHeartbeatTimeout()).add("DefaultTaskList", defaultTaskList())
                .add("DefaultTaskPriority", defaultTaskPriority())
                .add("DefaultTaskScheduleToStartTimeout", defaultTaskScheduleToStartTimeout())
                .add("DefaultTaskScheduleToCloseTimeout", defaultTaskScheduleToCloseTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultTaskStartToCloseTimeout":
            return Optional.ofNullable(clazz.cast(defaultTaskStartToCloseTimeout()));
        case "defaultTaskHeartbeatTimeout":
            return Optional.ofNullable(clazz.cast(defaultTaskHeartbeatTimeout()));
        case "defaultTaskList":
            return Optional.ofNullable(clazz.cast(defaultTaskList()));
        case "defaultTaskPriority":
            return Optional.ofNullable(clazz.cast(defaultTaskPriority()));
        case "defaultTaskScheduleToStartTimeout":
            return Optional.ofNullable(clazz.cast(defaultTaskScheduleToStartTimeout()));
        case "defaultTaskScheduleToCloseTimeout":
            return Optional.ofNullable(clazz.cast(defaultTaskScheduleToCloseTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivityTypeConfiguration, T> g) {
        return obj -> g.apply((ActivityTypeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActivityTypeConfiguration> {
        /**
         * <p>
         * The default maximum duration for tasks of an activity type specified when registering the activity type. You
         * can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
         * <a>Decision</a>.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskStartToCloseTimeout
         *        The default maximum duration for tasks of an activity type specified when registering the activity
         *        type. You can override this default when scheduling a task through the
         *        <code>ScheduleActivityTask</code> <a>Decision</a>.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout);

        /**
         * <p>
         * The default maximum time, in seconds, before which a worker processing a task must report progress by calling
         * <a>RecordActivityTaskHeartbeat</a>.
         * </p>
         * <p>
         * You can specify this value only when <i>registering</i> an activity type. The registered default value can be
         * overridden when you schedule a task through the <code>ScheduleActivityTask</code> <a>Decision</a>. If the
         * activity worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives
         * an <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to be
         * valid; the activity worker should clean up the activity task.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskHeartbeatTimeout
         *        The default maximum time, in seconds, before which a worker processing a task must report progress by
         *        calling <a>RecordActivityTaskHeartbeat</a>.</p>
         *        <p>
         *        You can specify this value only when <i>registering</i> an activity type. The registered default value
         *        can be overridden when you schedule a task through the <code>ScheduleActivityTask</code>
         *        <a>Decision</a>. If the activity worker subsequently attempts to record a heartbeat or returns a
         *        result, the activity worker receives an <code>UnknownResource</code> fault. In this case, Amazon SWF
         *        no longer considers the activity task to be valid; the activity worker should clean up the activity
         *        task.
         *        </p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskHeartbeatTimeout(String defaultTaskHeartbeatTimeout);

        /**
         * <p>
         * The default task list specified for this activity type at registration. This default is used if a task list
         * isn't provided when a task is scheduled through the <code>ScheduleActivityTask</code> <a>Decision</a>. You
         * can override the default registered task list when scheduling a task through the
         * <code>ScheduleActivityTask</code> <a>Decision</a>.
         * </p>
         * 
         * @param defaultTaskList
         *        The default task list specified for this activity type at registration. This default is used if a task
         *        list isn't provided when a task is scheduled through the <code>ScheduleActivityTask</code>
         *        <a>Decision</a>. You can override the default registered task list when scheduling a task through the
         *        <code>ScheduleActivityTask</code> <a>Decision</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskList(TaskList defaultTaskList);

        /**
         * <p>
         * The default task list specified for this activity type at registration. This default is used if a task list
         * isn't provided when a task is scheduled through the <code>ScheduleActivityTask</code> <a>Decision</a>. You
         * can override the default registered task list when scheduling a task through the
         * <code>ScheduleActivityTask</code> <a>Decision</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskList.Builder} avoiding the need to
         * create one manually via {@link TaskList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskList.Builder#build()} is called immediately and its result is
         * passed to {@link #defaultTaskList(TaskList)}.
         * 
         * @param defaultTaskList
         *        a consumer that will call methods on {@link TaskList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultTaskList(TaskList)
         */
        default Builder defaultTaskList(Consumer<TaskList.Builder> defaultTaskList) {
            return defaultTaskList(TaskList.builder().applyMutation(defaultTaskList).build());
        }

        /**
         * <p>
         * The default task priority for tasks of this activity type, specified at registration. If not set, then
         * <code>0</code> is used as the default priority. This default can be overridden when scheduling an activity
         * task.
         * </p>
         * <p>
         * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * 
         * @param defaultTaskPriority
         *        The default task priority for tasks of this activity type, specified at registration. If not set, then
         *        <code>0</code> is used as the default priority. This default can be overridden when scheduling an
         *        activity task.</p>
         *        <p>
         *        Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         *        <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         *        </p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskPriority(String defaultTaskPriority);

        /**
         * <p>
         * The default maximum duration, specified when registering the activity type, that a task of an activity type
         * can wait before being assigned to a worker. You can override this default when scheduling a task through the
         * <code>ScheduleActivityTask</code> <a>Decision</a>.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskScheduleToStartTimeout
         *        The default maximum duration, specified when registering the activity type, that a task of an activity
         *        type can wait before being assigned to a worker. You can override this default when scheduling a task
         *        through the <code>ScheduleActivityTask</code> <a>Decision</a>.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskScheduleToStartTimeout(String defaultTaskScheduleToStartTimeout);

        /**
         * <p>
         * The default maximum duration, specified when registering the activity type, for tasks of this activity type.
         * You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
         * <a>Decision</a>.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskScheduleToCloseTimeout
         *        The default maximum duration, specified when registering the activity type, for tasks of this activity
         *        type. You can override this default when scheduling a task through the
         *        <code>ScheduleActivityTask</code> <a>Decision</a>.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskScheduleToCloseTimeout(String defaultTaskScheduleToCloseTimeout);
    }

    static final class BuilderImpl implements Builder {
        private String defaultTaskStartToCloseTimeout;

        private String defaultTaskHeartbeatTimeout;

        private TaskList defaultTaskList;

        private String defaultTaskPriority;

        private String defaultTaskScheduleToStartTimeout;

        private String defaultTaskScheduleToCloseTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTypeConfiguration model) {
            defaultTaskStartToCloseTimeout(model.defaultTaskStartToCloseTimeout);
            defaultTaskHeartbeatTimeout(model.defaultTaskHeartbeatTimeout);
            defaultTaskList(model.defaultTaskList);
            defaultTaskPriority(model.defaultTaskPriority);
            defaultTaskScheduleToStartTimeout(model.defaultTaskScheduleToStartTimeout);
            defaultTaskScheduleToCloseTimeout(model.defaultTaskScheduleToCloseTimeout);
        }

        public final String getDefaultTaskStartToCloseTimeout() {
            return defaultTaskStartToCloseTimeout;
        }

        public final void setDefaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
            return this;
        }

        public final String getDefaultTaskHeartbeatTimeout() {
            return defaultTaskHeartbeatTimeout;
        }

        public final void setDefaultTaskHeartbeatTimeout(String defaultTaskHeartbeatTimeout) {
            this.defaultTaskHeartbeatTimeout = defaultTaskHeartbeatTimeout;
        }

        @Override
        public final Builder defaultTaskHeartbeatTimeout(String defaultTaskHeartbeatTimeout) {
            this.defaultTaskHeartbeatTimeout = defaultTaskHeartbeatTimeout;
            return this;
        }

        public final TaskList.Builder getDefaultTaskList() {
            return defaultTaskList != null ? defaultTaskList.toBuilder() : null;
        }

        public final void setDefaultTaskList(TaskList.BuilderImpl defaultTaskList) {
            this.defaultTaskList = defaultTaskList != null ? defaultTaskList.build() : null;
        }

        @Override
        public final Builder defaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
            return this;
        }

        public final String getDefaultTaskPriority() {
            return defaultTaskPriority;
        }

        public final void setDefaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
        }

        @Override
        public final Builder defaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
            return this;
        }

        public final String getDefaultTaskScheduleToStartTimeout() {
            return defaultTaskScheduleToStartTimeout;
        }

        public final void setDefaultTaskScheduleToStartTimeout(String defaultTaskScheduleToStartTimeout) {
            this.defaultTaskScheduleToStartTimeout = defaultTaskScheduleToStartTimeout;
        }

        @Override
        public final Builder defaultTaskScheduleToStartTimeout(String defaultTaskScheduleToStartTimeout) {
            this.defaultTaskScheduleToStartTimeout = defaultTaskScheduleToStartTimeout;
            return this;
        }

        public final String getDefaultTaskScheduleToCloseTimeout() {
            return defaultTaskScheduleToCloseTimeout;
        }

        public final void setDefaultTaskScheduleToCloseTimeout(String defaultTaskScheduleToCloseTimeout) {
            this.defaultTaskScheduleToCloseTimeout = defaultTaskScheduleToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskScheduleToCloseTimeout(String defaultTaskScheduleToCloseTimeout) {
            this.defaultTaskScheduleToCloseTimeout = defaultTaskScheduleToCloseTimeout;
            return this;
        }

        @Override
        public ActivityTypeConfiguration build() {
            return new ActivityTypeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
