/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supportapp.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supportapp.SupportAppClient;
import software.amazon.awssdk.services.supportapp.internal.UserAgentUtils;
import software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest;
import software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse;

public class ListSlackWorkspaceConfigurationsIterable
implements SdkIterable<ListSlackWorkspaceConfigurationsResponse> {
    private final SupportAppClient client;
    private final ListSlackWorkspaceConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSlackWorkspaceConfigurationsIterable(SupportAppClient client, ListSlackWorkspaceConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSlackWorkspaceConfigurationsResponseFetcher();
    }

    public Iterator<ListSlackWorkspaceConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSlackWorkspaceConfigurationsResponseFetcher
    implements SyncPageFetcher<ListSlackWorkspaceConfigurationsResponse> {
        private ListSlackWorkspaceConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSlackWorkspaceConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSlackWorkspaceConfigurationsResponse nextPage(ListSlackWorkspaceConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListSlackWorkspaceConfigurationsIterable.this.client.listSlackWorkspaceConfigurations(ListSlackWorkspaceConfigurationsIterable.this.firstRequest);
            }
            return ListSlackWorkspaceConfigurationsIterable.this.client.listSlackWorkspaceConfigurations((ListSlackWorkspaceConfigurationsRequest)((Object)ListSlackWorkspaceConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

