/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supportapp;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.supportapp.DefaultSupportAppBaseClientBuilder;
import software.amazon.awssdk.services.supportapp.DefaultSupportAppClient;
import software.amazon.awssdk.services.supportapp.SupportAppClient;
import software.amazon.awssdk.services.supportapp.SupportAppClientBuilder;
import software.amazon.awssdk.services.supportapp.SupportAppServiceClientConfiguration;
import software.amazon.awssdk.services.supportapp.endpoints.SupportAppEndpointProvider;

@SdkInternalApi
final class DefaultSupportAppClientBuilder
extends DefaultSupportAppBaseClientBuilder<SupportAppClientBuilder, SupportAppClient>
implements SupportAppClientBuilder {
    DefaultSupportAppClientBuilder() {
    }

    @Override
    public DefaultSupportAppClientBuilder endpointProvider(SupportAppEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SupportAppClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSupportAppClientBuilder.validateClientOptions(clientConfiguration);
        SupportAppServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSupportAppClient client = new DefaultSupportAppClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SupportAppServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SupportAppServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

