/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supportapp.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supportapp.SupportAppClient;
import software.amazon.awssdk.services.supportapp.internal.UserAgentUtils;
import software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest;
import software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsResponse;

public class ListSlackChannelConfigurationsIterable
implements SdkIterable<ListSlackChannelConfigurationsResponse> {
    private final SupportAppClient client;
    private final ListSlackChannelConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSlackChannelConfigurationsIterable(SupportAppClient client, ListSlackChannelConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSlackChannelConfigurationsResponseFetcher();
    }

    public Iterator<ListSlackChannelConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSlackChannelConfigurationsResponseFetcher
    implements SyncPageFetcher<ListSlackChannelConfigurationsResponse> {
        private ListSlackChannelConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSlackChannelConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSlackChannelConfigurationsResponse nextPage(ListSlackChannelConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListSlackChannelConfigurationsIterable.this.client.listSlackChannelConfigurations(ListSlackChannelConfigurationsIterable.this.firstRequest);
            }
            return ListSlackChannelConfigurationsIterable.this.client.listSlackChannelConfigurations((ListSlackChannelConfigurationsRequest)((Object)ListSlackChannelConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

