/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.support.model.SupportResponse;
import software.amazon.awssdk.services.support.model.TrustedAdvisorCheckDescription;
import software.amazon.awssdk.services.support.model.TrustedAdvisorCheckListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrustedAdvisorChecksResponse
extends SupportResponse
implements ToCopyableBuilder<Builder, DescribeTrustedAdvisorChecksResponse> {
    private static final SdkField<List<TrustedAdvisorCheckDescription>> CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTrustedAdvisorChecksResponse.getter(DescribeTrustedAdvisorChecksResponse::checks)).setter(DescribeTrustedAdvisorChecksResponse.setter(Builder::checks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrustedAdvisorCheckDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKS_FIELD));
    private final List<TrustedAdvisorCheckDescription> checks;

    private DescribeTrustedAdvisorChecksResponse(BuilderImpl builder) {
        super(builder);
        this.checks = builder.checks;
    }

    public List<TrustedAdvisorCheckDescription> checks() {
        return this.checks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorChecksResponse)) {
            return false;
        }
        DescribeTrustedAdvisorChecksResponse other = (DescribeTrustedAdvisorChecksResponse)((Object)obj);
        return Objects.equals(this.checks(), other.checks());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTrustedAdvisorChecksResponse").add("Checks", this.checks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checks": {
                return Optional.ofNullable(clazz.cast(this.checks()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedAdvisorChecksResponse, T> g) {
        return obj -> g.apply((DescribeTrustedAdvisorChecksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportResponse.BuilderImpl
    implements Builder {
        private List<TrustedAdvisorCheckDescription> checks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorChecksResponse model) {
            super(model);
            this.checks(model.checks);
        }

        public final Collection<TrustedAdvisorCheckDescription.Builder> getChecks() {
            return this.checks != null ? (Collection)this.checks.stream().map(TrustedAdvisorCheckDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder checks(Collection<TrustedAdvisorCheckDescription> checks) {
            this.checks = TrustedAdvisorCheckListCopier.copy(checks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checks(TrustedAdvisorCheckDescription ... checks) {
            this.checks(Arrays.asList(checks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checks(Consumer<TrustedAdvisorCheckDescription.Builder> ... checks) {
            this.checks(Stream.of(checks).map(c -> (TrustedAdvisorCheckDescription)((TrustedAdvisorCheckDescription.Builder)TrustedAdvisorCheckDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChecks(Collection<TrustedAdvisorCheckDescription.BuilderImpl> checks) {
            this.checks = TrustedAdvisorCheckListCopier.copyFromBuilder(checks);
        }

        @Override
        public DescribeTrustedAdvisorChecksResponse build() {
            return new DescribeTrustedAdvisorChecksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SupportResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrustedAdvisorChecksResponse> {
        public Builder checks(Collection<TrustedAdvisorCheckDescription> var1);

        public Builder checks(TrustedAdvisorCheckDescription ... var1);

        public Builder checks(Consumer<TrustedAdvisorCheckDescription.Builder> ... var1);
    }
}

