/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description and metadata for a Trusted Advisor check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustedAdvisorCheckDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<TrustedAdvisorCheckDescription.Builder, TrustedAdvisorCheckDescription> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(TrustedAdvisorCheckDescription::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TrustedAdvisorCheckDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TrustedAdvisorCheckDescription::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(TrustedAdvisorCheckDescription::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<List<String>> METADATA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("metadata")
            .getter(getter(TrustedAdvisorCheckDescription::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CATEGORY_FIELD, METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String category;

    private final List<String> metadata;

    private TrustedAdvisorCheckDescription(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.category = builder.category;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The display name for the Trusted Advisor check.
     * </p>
     * 
     * @return The display name for the Trusted Advisor check.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the Trusted Advisor check, which includes the alert criteria and recommended operations
     * (contains HTML markup).
     * </p>
     * 
     * @return The description of the Trusted Advisor check, which includes the alert criteria and recommended
     *         operations (contains HTML markup).
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The category of the Trusted Advisor check.
     * </p>
     * 
     * @return The category of the Trusted Advisor check.
     */
    public final String category() {
        return category;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds to
     * the order of the data in the <b>Metadata</b> element of the <a>TrustedAdvisorResourceDetail</a> for the check.
     * <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows
     * just summary data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return The column headings for the data returned by the Trusted Advisor check. The order of the headings
     *         corresponds to the order of the data in the <b>Metadata</b> element of the
     *         <a>TrustedAdvisorResourceDetail</a> for the check. <b>Metadata</b> contains all the data that is shown in
     *         the Excel download, even in those cases where the UI shows just summary data.
     */
    public final List<String> metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckDescription)) {
            return false;
        }
        TrustedAdvisorCheckDescription other = (TrustedAdvisorCheckDescription) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(category(), other.category())
                && hasMetadata() == other.hasMetadata() && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrustedAdvisorCheckDescription").add("Id", id()).add("Name", name())
                .add("Description", description()).add("Category", category()).add("Metadata", hasMetadata() ? metadata() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "category":
            return Optional.ofNullable(clazz.cast(category()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("category", CATEGORY_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrustedAdvisorCheckDescription, T> g) {
        return obj -> g.apply((TrustedAdvisorCheckDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustedAdvisorCheckDescription> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check.
         * </p>
         * 
         * @param id
         *        The unique identifier for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The display name for the Trusted Advisor check.
         * </p>
         * 
         * @param name
         *        The display name for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the Trusted Advisor check, which includes the alert criteria and recommended operations
         * (contains HTML markup).
         * </p>
         * 
         * @param description
         *        The description of the Trusted Advisor check, which includes the alert criteria and recommended
         *        operations (contains HTML markup).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The category of the Trusted Advisor check.
         * </p>
         * 
         * @param category
         *        The category of the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds
         * to the order of the data in the <b>Metadata</b> element of the <a>TrustedAdvisorResourceDetail</a> for the
         * check. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where
         * the UI shows just summary data.
         * </p>
         * 
         * @param metadata
         *        The column headings for the data returned by the Trusted Advisor check. The order of the headings
         *        corresponds to the order of the data in the <b>Metadata</b> element of the
         *        <a>TrustedAdvisorResourceDetail</a> for the check. <b>Metadata</b> contains all the data that is shown
         *        in the Excel download, even in those cases where the UI shows just summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Collection<String> metadata);

        /**
         * <p>
         * The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds
         * to the order of the data in the <b>Metadata</b> element of the <a>TrustedAdvisorResourceDetail</a> for the
         * check. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where
         * the UI shows just summary data.
         * </p>
         * 
         * @param metadata
         *        The column headings for the data returned by the Trusted Advisor check. The order of the headings
         *        corresponds to the order of the data in the <b>Metadata</b> element of the
         *        <a>TrustedAdvisorResourceDetail</a> for the check. <b>Metadata</b> contains all the data that is shown
         *        in the Excel download, even in those cases where the UI shows just summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String... metadata);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String category;

        private List<String> metadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckDescription model) {
            id(model.id);
            name(model.name);
            description(model.description);
            category(model.category);
            metadata(model.metadata);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final Collection<String> getMetadata() {
            if (metadata instanceof SdkAutoConstructList) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(String... metadata) {
            metadata(Arrays.asList(metadata));
            return this;
        }

        @Override
        public TrustedAdvisorCheckDescription build() {
            return new TrustedAdvisorCheckDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
