/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Date and time (UTC) format in RFC 3339 : 'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateInterval implements SdkPojo, Serializable, ToCopyableBuilder<DateInterval.Builder, DateInterval> {
    private static final SdkField<String> START_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startDateTime").getter(getter(DateInterval::startDateTime)).setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()).build();

    private static final SdkField<String> END_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endDateTime").getter(getter(DateInterval::endDateTime)).setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_DATE_TIME_FIELD,
            END_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String startDateTime;

    private final String endDateTime;

    private DateInterval(BuilderImpl builder) {
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
    }

    /**
     * <p>
     * A JSON object containing start and date time (UTC). Date and time format is RFC 3339 :
     * 'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
     * </p>
     * 
     * @return A JSON object containing start and date time (UTC). Date and time format is RFC 3339 :
     *         'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
     */
    public final String startDateTime() {
        return startDateTime;
    }

    /**
     * <p>
     * End Date Time (UTC). RFC 3339 format : 'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
     * </p>
     * 
     * @return End Date Time (UTC). RFC 3339 format : 'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
     */
    public final String endDateTime() {
        return endDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateInterval)) {
            return false;
        }
        DateInterval other = (DateInterval) obj;
        return Objects.equals(startDateTime(), other.startDateTime()) && Objects.equals(endDateTime(), other.endDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateInterval").add("StartDateTime", startDateTime()).add("EndDateTime", endDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "endDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startDateTime", START_DATE_TIME_FIELD);
        map.put("endDateTime", END_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateInterval, T> g) {
        return obj -> g.apply((DateInterval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateInterval> {
        /**
         * <p>
         * A JSON object containing start and date time (UTC). Date and time format is RFC 3339 :
         * 'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
         * </p>
         * 
         * @param startDateTime
         *        A JSON object containing start and date time (UTC). Date and time format is RFC 3339 :
         *        'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateTime(String startDateTime);

        /**
         * <p>
         * End Date Time (UTC). RFC 3339 format : 'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
         * </p>
         * 
         * @param endDateTime
         *        End Date Time (UTC). RFC 3339 format : 'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(String endDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String startDateTime;

        private String endDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DateInterval model) {
            startDateTime(model.startDateTime);
            endDateTime(model.endDateTime);
        }

        public final String getStartDateTime() {
            return startDateTime;
        }

        public final void setStartDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final String getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        @Override
        public DateInterval build() {
            return new DateInterval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
