/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.AttachmentDetails;
import software.amazon.awssdk.services.support.model.AttachmentSetCopier;
import software.amazon.awssdk.services.support.transform.CommunicationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Communication
implements StructuredPojo,
ToCopyableBuilder<Builder, Communication> {
    private final String caseId;
    private final String body;
    private final String submittedBy;
    private final String timeCreated;
    private final List<AttachmentDetails> attachmentSet;

    private Communication(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.body = builder.body;
        this.submittedBy = builder.submittedBy;
        this.timeCreated = builder.timeCreated;
        this.attachmentSet = builder.attachmentSet;
    }

    public String caseId() {
        return this.caseId;
    }

    public String body() {
        return this.body;
    }

    public String submittedBy() {
        return this.submittedBy;
    }

    public String timeCreated() {
        return this.timeCreated;
    }

    public List<AttachmentDetails> attachmentSet() {
        return this.attachmentSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Communication)) {
            return false;
        }
        Communication other = (Communication)obj;
        return Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.submittedBy(), other.submittedBy()) && Objects.equals(this.timeCreated(), other.timeCreated()) && Objects.equals(this.attachmentSet(), other.attachmentSet());
    }

    public String toString() {
        return ToString.builder((String)"Communication").add("CaseId", (Object)this.caseId()).add("Body", (Object)this.body()).add("SubmittedBy", (Object)this.submittedBy()).add("TimeCreated", (Object)this.timeCreated()).add("AttachmentSet", this.attachmentSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseId": {
                return Optional.of(clazz.cast(this.caseId()));
            }
            case "body": {
                return Optional.of(clazz.cast(this.body()));
            }
            case "submittedBy": {
                return Optional.of(clazz.cast(this.submittedBy()));
            }
            case "timeCreated": {
                return Optional.of(clazz.cast(this.timeCreated()));
            }
            case "attachmentSet": {
                return Optional.of(clazz.cast(this.attachmentSet()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommunicationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String caseId;
        private String body;
        private String submittedBy;
        private String timeCreated;
        private List<AttachmentDetails> attachmentSet;

        private BuilderImpl() {
        }

        private BuilderImpl(Communication model) {
            this.caseId(model.caseId);
            this.body(model.body);
            this.submittedBy(model.submittedBy);
            this.timeCreated(model.timeCreated);
            this.attachmentSet(model.attachmentSet);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getSubmittedBy() {
            return this.submittedBy;
        }

        @Override
        public final Builder submittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public final void setSubmittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
        }

        public final String getTimeCreated() {
            return this.timeCreated;
        }

        @Override
        public final Builder timeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
        }

        public final Collection<AttachmentDetails.Builder> getAttachmentSet() {
            return this.attachmentSet != null ? (Collection)this.attachmentSet.stream().map(AttachmentDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachmentSet(Collection<AttachmentDetails> attachmentSet) {
            this.attachmentSet = AttachmentSetCopier.copy(attachmentSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentSet(AttachmentDetails ... attachmentSet) {
            this.attachmentSet(Arrays.asList(attachmentSet));
            return this;
        }

        public final void setAttachmentSet(Collection<AttachmentDetails.BuilderImpl> attachmentSet) {
            this.attachmentSet = AttachmentSetCopier.copyFromBuilder(attachmentSet);
        }

        public Communication build() {
            return new Communication(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Communication> {
        public Builder caseId(String var1);

        public Builder body(String var1);

        public Builder submittedBy(String var1);

        public Builder timeCreated(String var1);

        public Builder attachmentSet(Collection<AttachmentDetails> var1);

        public Builder attachmentSet(AttachmentDetails ... var1);
    }
}

