/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.support.model.RecentCaseCommunications;

@SdkInternalApi
public class RecentCaseCommunicationsMarshaller {
    private static final MarshallingInfo<List> COMMUNICATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("communications").build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").build();
    private static final RecentCaseCommunicationsMarshaller INSTANCE = new RecentCaseCommunicationsMarshaller();

    public static RecentCaseCommunicationsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecentCaseCommunications recentCaseCommunications, ProtocolMarshaller protocolMarshaller) {
        if (recentCaseCommunications == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(recentCaseCommunications.communications(), COMMUNICATIONS_BINDING);
            protocolMarshaller.marshall((Object)recentCaseCommunications.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

