/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.support.SupportClient;
import software.amazon.awssdk.services.support.model.AddAttachmentsToSetRequest;
import software.amazon.awssdk.services.support.model.AddAttachmentsToSetResponse;
import software.amazon.awssdk.services.support.model.AddCommunicationToCaseRequest;
import software.amazon.awssdk.services.support.model.AddCommunicationToCaseResponse;
import software.amazon.awssdk.services.support.model.AttachmentIdNotFoundException;
import software.amazon.awssdk.services.support.model.AttachmentLimitExceededException;
import software.amazon.awssdk.services.support.model.AttachmentSetExpiredException;
import software.amazon.awssdk.services.support.model.AttachmentSetIdNotFoundException;
import software.amazon.awssdk.services.support.model.AttachmentSetSizeLimitExceededException;
import software.amazon.awssdk.services.support.model.CaseCreationLimitExceededException;
import software.amazon.awssdk.services.support.model.CaseIdNotFoundException;
import software.amazon.awssdk.services.support.model.CreateCaseRequest;
import software.amazon.awssdk.services.support.model.CreateCaseResponse;
import software.amazon.awssdk.services.support.model.DescribeAttachmentLimitExceededException;
import software.amazon.awssdk.services.support.model.DescribeAttachmentRequest;
import software.amazon.awssdk.services.support.model.DescribeAttachmentResponse;
import software.amazon.awssdk.services.support.model.DescribeCasesRequest;
import software.amazon.awssdk.services.support.model.DescribeCasesResponse;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsResponse;
import software.amazon.awssdk.services.support.model.DescribeServicesRequest;
import software.amazon.awssdk.services.support.model.DescribeServicesResponse;
import software.amazon.awssdk.services.support.model.DescribeSeverityLevelsRequest;
import software.amazon.awssdk.services.support.model.DescribeSeverityLevelsResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckResultRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckResultResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckSummariesRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorCheckSummariesResponse;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorChecksRequest;
import software.amazon.awssdk.services.support.model.DescribeTrustedAdvisorChecksResponse;
import software.amazon.awssdk.services.support.model.InternalServerErrorException;
import software.amazon.awssdk.services.support.model.RefreshTrustedAdvisorCheckRequest;
import software.amazon.awssdk.services.support.model.RefreshTrustedAdvisorCheckResponse;
import software.amazon.awssdk.services.support.model.ResolveCaseRequest;
import software.amazon.awssdk.services.support.model.ResolveCaseResponse;
import software.amazon.awssdk.services.support.model.SupportException;
import software.amazon.awssdk.services.support.paginators.DescribeCasesPaginator;
import software.amazon.awssdk.services.support.paginators.DescribeCommunicationsPaginator;
import software.amazon.awssdk.services.support.transform.AddAttachmentsToSetRequestMarshaller;
import software.amazon.awssdk.services.support.transform.AddAttachmentsToSetResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.AddCommunicationToCaseRequestMarshaller;
import software.amazon.awssdk.services.support.transform.AddCommunicationToCaseResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.CreateCaseRequestMarshaller;
import software.amazon.awssdk.services.support.transform.CreateCaseResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.DescribeAttachmentRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeAttachmentResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.DescribeCasesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeCasesResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.DescribeCommunicationsRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeCommunicationsResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.DescribeServicesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeServicesResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.DescribeSeverityLevelsRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeSeverityLevelsResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckRefreshStatusesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckRefreshStatusesResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckResultRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckResultResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckSummariesRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorCheckSummariesResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorChecksRequestMarshaller;
import software.amazon.awssdk.services.support.transform.DescribeTrustedAdvisorChecksResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.RefreshTrustedAdvisorCheckRequestMarshaller;
import software.amazon.awssdk.services.support.transform.RefreshTrustedAdvisorCheckResponseUnmarshaller;
import software.amazon.awssdk.services.support.transform.ResolveCaseRequestMarshaller;
import software.amazon.awssdk.services.support.transform.ResolveCaseResponseUnmarshaller;

@SdkInternalApi
final class DefaultSupportClient
implements SupportClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultSupportClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public AddAttachmentsToSetResponse addAttachmentsToSet(AddAttachmentsToSetRequest addAttachmentsToSetRequest) throws InternalServerErrorException, AttachmentSetIdNotFoundException, AttachmentSetExpiredException, AttachmentSetSizeLimitExceededException, AttachmentLimitExceededException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddAttachmentsToSetResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddAttachmentsToSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addAttachmentsToSetRequest).withMarshaller((Marshaller)new AddAttachmentsToSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AddCommunicationToCaseResponse addCommunicationToCase(AddCommunicationToCaseRequest addCommunicationToCaseRequest) throws InternalServerErrorException, CaseIdNotFoundException, AttachmentSetIdNotFoundException, AttachmentSetExpiredException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddCommunicationToCaseResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddCommunicationToCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addCommunicationToCaseRequest).withMarshaller((Marshaller)new AddCommunicationToCaseRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateCaseResponse createCase(CreateCaseRequest createCaseRequest) throws InternalServerErrorException, CaseCreationLimitExceededException, AttachmentSetIdNotFoundException, AttachmentSetExpiredException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCaseResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCaseRequest).withMarshaller((Marshaller)new CreateCaseRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAttachmentResponse describeAttachment(DescribeAttachmentRequest describeAttachmentRequest) throws InternalServerErrorException, DescribeAttachmentLimitExceededException, AttachmentIdNotFoundException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAttachmentResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeAttachmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAttachmentRequest).withMarshaller((Marshaller)new DescribeAttachmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeCasesResponse describeCases(DescribeCasesRequest describeCasesRequest) throws InternalServerErrorException, CaseIdNotFoundException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeCasesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeCasesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCasesRequest).withMarshaller((Marshaller)new DescribeCasesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeCasesPaginator describeCasesIterable(DescribeCasesRequest describeCasesRequest) throws InternalServerErrorException, CaseIdNotFoundException, SdkServiceException, SdkClientException, SupportException {
        return new DescribeCasesPaginator(this, describeCasesRequest);
    }

    @Override
    public DescribeCommunicationsResponse describeCommunications(DescribeCommunicationsRequest describeCommunicationsRequest) throws InternalServerErrorException, CaseIdNotFoundException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeCommunicationsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeCommunicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCommunicationsRequest).withMarshaller((Marshaller)new DescribeCommunicationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeCommunicationsPaginator describeCommunicationsIterable(DescribeCommunicationsRequest describeCommunicationsRequest) throws InternalServerErrorException, CaseIdNotFoundException, SdkServiceException, SdkClientException, SupportException {
        return new DescribeCommunicationsPaginator(this, describeCommunicationsRequest);
    }

    @Override
    public DescribeServicesResponse describeServices(DescribeServicesRequest describeServicesRequest) throws InternalServerErrorException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeServicesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServicesRequest).withMarshaller((Marshaller)new DescribeServicesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeSeverityLevelsResponse describeSeverityLevels(DescribeSeverityLevelsRequest describeSeverityLevelsRequest) throws InternalServerErrorException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSeverityLevelsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeSeverityLevelsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSeverityLevelsRequest).withMarshaller((Marshaller)new DescribeSeverityLevelsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTrustedAdvisorCheckRefreshStatusesResponse describeTrustedAdvisorCheckRefreshStatuses(DescribeTrustedAdvisorCheckRefreshStatusesRequest describeTrustedAdvisorCheckRefreshStatusesRequest) throws InternalServerErrorException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTrustedAdvisorCheckRefreshStatusesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeTrustedAdvisorCheckRefreshStatusesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTrustedAdvisorCheckRefreshStatusesRequest).withMarshaller((Marshaller)new DescribeTrustedAdvisorCheckRefreshStatusesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTrustedAdvisorCheckResultResponse describeTrustedAdvisorCheckResult(DescribeTrustedAdvisorCheckResultRequest describeTrustedAdvisorCheckResultRequest) throws InternalServerErrorException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTrustedAdvisorCheckResultResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeTrustedAdvisorCheckResultResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTrustedAdvisorCheckResultRequest).withMarshaller((Marshaller)new DescribeTrustedAdvisorCheckResultRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTrustedAdvisorCheckSummariesResponse describeTrustedAdvisorCheckSummaries(DescribeTrustedAdvisorCheckSummariesRequest describeTrustedAdvisorCheckSummariesRequest) throws InternalServerErrorException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTrustedAdvisorCheckSummariesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeTrustedAdvisorCheckSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTrustedAdvisorCheckSummariesRequest).withMarshaller((Marshaller)new DescribeTrustedAdvisorCheckSummariesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeTrustedAdvisorChecksResponse describeTrustedAdvisorChecks(DescribeTrustedAdvisorChecksRequest describeTrustedAdvisorChecksRequest) throws InternalServerErrorException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTrustedAdvisorChecksResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeTrustedAdvisorChecksResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTrustedAdvisorChecksRequest).withMarshaller((Marshaller)new DescribeTrustedAdvisorChecksRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RefreshTrustedAdvisorCheckResponse refreshTrustedAdvisorCheck(RefreshTrustedAdvisorCheckRequest refreshTrustedAdvisorCheckRequest) throws InternalServerErrorException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RefreshTrustedAdvisorCheckResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RefreshTrustedAdvisorCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)refreshTrustedAdvisorCheckRequest).withMarshaller((Marshaller)new RefreshTrustedAdvisorCheckRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ResolveCaseResponse resolveCase(ResolveCaseRequest resolveCaseRequest) throws InternalServerErrorException, CaseIdNotFoundException, SdkServiceException, SdkClientException, SupportException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ResolveCaseResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ResolveCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resolveCaseRequest).withMarshaller((Marshaller)new ResolveCaseRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(SupportException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AttachmentSetIdNotFound").withModeledClass(AttachmentSetIdNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CaseCreationLimitExceeded").withModeledClass(CaseCreationLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AttachmentIdNotFound").withModeledClass(AttachmentIdNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AttachmentSetExpired").withModeledClass(AttachmentSetExpiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AttachmentLimitExceeded").withModeledClass(AttachmentLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CaseIdNotFound").withModeledClass(CaseIdNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DescribeAttachmentLimitExceeded").withModeledClass(DescribeAttachmentLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AttachmentSetSizeLimitExceeded").withModeledClass(AttachmentSetSizeLimitExceededException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

