/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.support.SupportClient;
import software.amazon.awssdk.services.support.model.CaseDetails;
import software.amazon.awssdk.services.support.model.DescribeCasesRequest;
import software.amazon.awssdk.services.support.model.DescribeCasesResponse;

public final class DescribeCasesPaginator
implements SdkIterable<DescribeCasesResponse> {
    private final SupportClient client;
    private final DescribeCasesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeCasesPaginator(SupportClient client, DescribeCasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCasesResponseFetcher();
    }

    public Iterator<DescribeCasesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<CaseDetails> cases() {
        Function<DescribeCasesResponse, Iterator> getIterator = response -> response != null ? response.cases().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeCasesResponseFetcher
    implements NextPageFetcher<DescribeCasesResponse> {
        private DescribeCasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCasesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeCasesResponse nextPage(DescribeCasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCasesPaginator.this.client.describeCases(DescribeCasesPaginator.this.firstRequest);
            }
            return DescribeCasesPaginator.this.client.describeCases((DescribeCasesRequest)((Object)DescribeCasesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

