/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCostOptimizingSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TrustedAdvisorCostOptimizingSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, TrustedAdvisorCostOptimizingSummary> {
    private final Double estimatedMonthlySavings;
    private final Double estimatedPercentMonthlySavings;

    private TrustedAdvisorCostOptimizingSummary(BuilderImpl builder) {
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.estimatedPercentMonthlySavings = builder.estimatedPercentMonthlySavings;
    }

    public Double estimatedMonthlySavings() {
        return this.estimatedMonthlySavings;
    }

    public Double estimatedPercentMonthlySavings() {
        return this.estimatedPercentMonthlySavings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.estimatedMonthlySavings() == null ? 0 : this.estimatedMonthlySavings().hashCode());
        hashCode = 31 * hashCode + (this.estimatedPercentMonthlySavings() == null ? 0 : this.estimatedPercentMonthlySavings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCostOptimizingSummary)) {
            return false;
        }
        TrustedAdvisorCostOptimizingSummary other = (TrustedAdvisorCostOptimizingSummary)obj;
        if (other.estimatedMonthlySavings() == null ^ this.estimatedMonthlySavings() == null) {
            return false;
        }
        if (other.estimatedMonthlySavings() != null && !other.estimatedMonthlySavings().equals(this.estimatedMonthlySavings())) {
            return false;
        }
        if (other.estimatedPercentMonthlySavings() == null ^ this.estimatedPercentMonthlySavings() == null) {
            return false;
        }
        return other.estimatedPercentMonthlySavings() == null || other.estimatedPercentMonthlySavings().equals(this.estimatedPercentMonthlySavings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.estimatedMonthlySavings() != null) {
            sb.append("EstimatedMonthlySavings: ").append(this.estimatedMonthlySavings()).append(",");
        }
        if (this.estimatedPercentMonthlySavings() != null) {
            sb.append("EstimatedPercentMonthlySavings: ").append(this.estimatedPercentMonthlySavings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "estimatedMonthlySavings": {
                return Optional.of(clazz.cast(this.estimatedMonthlySavings()));
            }
            case "estimatedPercentMonthlySavings": {
                return Optional.of(clazz.cast(this.estimatedPercentMonthlySavings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCostOptimizingSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Double estimatedMonthlySavings;
        private Double estimatedPercentMonthlySavings;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCostOptimizingSummary model) {
            this.estimatedMonthlySavings(model.estimatedMonthlySavings);
            this.estimatedPercentMonthlySavings(model.estimatedPercentMonthlySavings);
        }

        public final Double getEstimatedMonthlySavings() {
            return this.estimatedMonthlySavings;
        }

        @Override
        public final Builder estimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final void setEstimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
        }

        public final Double getEstimatedPercentMonthlySavings() {
            return this.estimatedPercentMonthlySavings;
        }

        @Override
        public final Builder estimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings) {
            this.estimatedPercentMonthlySavings = estimatedPercentMonthlySavings;
            return this;
        }

        public final void setEstimatedPercentMonthlySavings(Double estimatedPercentMonthlySavings) {
            this.estimatedPercentMonthlySavings = estimatedPercentMonthlySavings;
        }

        public TrustedAdvisorCostOptimizingSummary build() {
            return new TrustedAdvisorCostOptimizingSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrustedAdvisorCostOptimizingSummary> {
        public Builder estimatedMonthlySavings(Double var1);

        public Builder estimatedPercentMonthlySavings(Double var1);
    }
}

