/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.support.model.CaseIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCasesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeCasesRequest> {
    private final List<String> caseIdList;
    private final String displayId;
    private final String afterTime;
    private final String beforeTime;
    private final Boolean includeResolvedCases;
    private final String nextToken;
    private final Integer maxResults;
    private final String language;
    private final Boolean includeCommunications;

    private DescribeCasesRequest(BuilderImpl builder) {
        this.caseIdList = builder.caseIdList;
        this.displayId = builder.displayId;
        this.afterTime = builder.afterTime;
        this.beforeTime = builder.beforeTime;
        this.includeResolvedCases = builder.includeResolvedCases;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.language = builder.language;
        this.includeCommunications = builder.includeCommunications;
    }

    public List<String> caseIdList() {
        return this.caseIdList;
    }

    public String displayId() {
        return this.displayId;
    }

    public String afterTime() {
        return this.afterTime;
    }

    public String beforeTime() {
        return this.beforeTime;
    }

    public Boolean includeResolvedCases() {
        return this.includeResolvedCases;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String language() {
        return this.language;
    }

    public Boolean includeCommunications() {
        return this.includeCommunications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.caseIdList() == null ? 0 : this.caseIdList().hashCode());
        hashCode = 31 * hashCode + (this.displayId() == null ? 0 : this.displayId().hashCode());
        hashCode = 31 * hashCode + (this.afterTime() == null ? 0 : this.afterTime().hashCode());
        hashCode = 31 * hashCode + (this.beforeTime() == null ? 0 : this.beforeTime().hashCode());
        hashCode = 31 * hashCode + (this.includeResolvedCases() == null ? 0 : this.includeResolvedCases().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.language() == null ? 0 : this.language().hashCode());
        hashCode = 31 * hashCode + (this.includeCommunications() == null ? 0 : this.includeCommunications().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCasesRequest)) {
            return false;
        }
        DescribeCasesRequest other = (DescribeCasesRequest)((Object)obj);
        if (other.caseIdList() == null ^ this.caseIdList() == null) {
            return false;
        }
        if (other.caseIdList() != null && !other.caseIdList().equals(this.caseIdList())) {
            return false;
        }
        if (other.displayId() == null ^ this.displayId() == null) {
            return false;
        }
        if (other.displayId() != null && !other.displayId().equals(this.displayId())) {
            return false;
        }
        if (other.afterTime() == null ^ this.afterTime() == null) {
            return false;
        }
        if (other.afterTime() != null && !other.afterTime().equals(this.afterTime())) {
            return false;
        }
        if (other.beforeTime() == null ^ this.beforeTime() == null) {
            return false;
        }
        if (other.beforeTime() != null && !other.beforeTime().equals(this.beforeTime())) {
            return false;
        }
        if (other.includeResolvedCases() == null ^ this.includeResolvedCases() == null) {
            return false;
        }
        if (other.includeResolvedCases() != null && !other.includeResolvedCases().equals(this.includeResolvedCases())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.language() == null ^ this.language() == null) {
            return false;
        }
        if (other.language() != null && !other.language().equals(this.language())) {
            return false;
        }
        if (other.includeCommunications() == null ^ this.includeCommunications() == null) {
            return false;
        }
        return other.includeCommunications() == null || other.includeCommunications().equals(this.includeCommunications());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caseIdList() != null) {
            sb.append("CaseIdList: ").append(this.caseIdList()).append(",");
        }
        if (this.displayId() != null) {
            sb.append("DisplayId: ").append(this.displayId()).append(",");
        }
        if (this.afterTime() != null) {
            sb.append("AfterTime: ").append(this.afterTime()).append(",");
        }
        if (this.beforeTime() != null) {
            sb.append("BeforeTime: ").append(this.beforeTime()).append(",");
        }
        if (this.includeResolvedCases() != null) {
            sb.append("IncludeResolvedCases: ").append(this.includeResolvedCases()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.language() != null) {
            sb.append("Language: ").append(this.language()).append(",");
        }
        if (this.includeCommunications() != null) {
            sb.append("IncludeCommunications: ").append(this.includeCommunications()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> caseIdList;
        private String displayId;
        private String afterTime;
        private String beforeTime;
        private Boolean includeResolvedCases;
        private String nextToken;
        private Integer maxResults;
        private String language;
        private Boolean includeCommunications;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCasesRequest model) {
            this.setCaseIdList(model.caseIdList);
            this.setDisplayId(model.displayId);
            this.setAfterTime(model.afterTime);
            this.setBeforeTime(model.beforeTime);
            this.setIncludeResolvedCases(model.includeResolvedCases);
            this.setNextToken(model.nextToken);
            this.setMaxResults(model.maxResults);
            this.setLanguage(model.language);
            this.setIncludeCommunications(model.includeCommunications);
        }

        public final Collection<String> getCaseIdList() {
            return this.caseIdList;
        }

        @Override
        public final Builder caseIdList(Collection<String> caseIdList) {
            this.caseIdList = CaseIdListCopier.copy(caseIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseIdList(String ... caseIdList) {
            this.caseIdList(Arrays.asList(caseIdList));
            return this;
        }

        public final void setCaseIdList(Collection<String> caseIdList) {
            this.caseIdList = CaseIdListCopier.copy(caseIdList);
        }

        public final String getDisplayId() {
            return this.displayId;
        }

        @Override
        public final Builder displayId(String displayId) {
            this.displayId = displayId;
            return this;
        }

        public final void setDisplayId(String displayId) {
            this.displayId = displayId;
        }

        public final String getAfterTime() {
            return this.afterTime;
        }

        @Override
        public final Builder afterTime(String afterTime) {
            this.afterTime = afterTime;
            return this;
        }

        public final void setAfterTime(String afterTime) {
            this.afterTime = afterTime;
        }

        public final String getBeforeTime() {
            return this.beforeTime;
        }

        @Override
        public final Builder beforeTime(String beforeTime) {
            this.beforeTime = beforeTime;
            return this;
        }

        public final void setBeforeTime(String beforeTime) {
            this.beforeTime = beforeTime;
        }

        public final Boolean getIncludeResolvedCases() {
            return this.includeResolvedCases;
        }

        @Override
        public final Builder includeResolvedCases(Boolean includeResolvedCases) {
            this.includeResolvedCases = includeResolvedCases;
            return this;
        }

        public final void setIncludeResolvedCases(Boolean includeResolvedCases) {
            this.includeResolvedCases = includeResolvedCases;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getLanguage() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final Boolean getIncludeCommunications() {
            return this.includeCommunications;
        }

        @Override
        public final Builder includeCommunications(Boolean includeCommunications) {
            this.includeCommunications = includeCommunications;
            return this;
        }

        public final void setIncludeCommunications(Boolean includeCommunications) {
            this.includeCommunications = includeCommunications;
        }

        public DescribeCasesRequest build() {
            return new DescribeCasesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCasesRequest> {
        public Builder caseIdList(Collection<String> var1);

        public Builder caseIdList(String ... var1);

        public Builder displayId(String var1);

        public Builder afterTime(String var1);

        public Builder beforeTime(String var1);

        public Builder includeResolvedCases(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder language(String var1);

        public Builder includeCommunications(Boolean var1);
    }
}

