/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.support.model.ServiceCodeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeServicesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeServicesRequest> {
    private final List<String> serviceCodeList;
    private final String language;

    private DescribeServicesRequest(BuilderImpl builder) {
        this.serviceCodeList = builder.serviceCodeList;
        this.language = builder.language;
    }

    public List<String> serviceCodeList() {
        return this.serviceCodeList;
    }

    public String language() {
        return this.language;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.serviceCodeList() == null ? 0 : this.serviceCodeList().hashCode());
        hashCode = 31 * hashCode + (this.language() == null ? 0 : this.language().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesRequest)) {
            return false;
        }
        DescribeServicesRequest other = (DescribeServicesRequest)((Object)obj);
        if (other.serviceCodeList() == null ^ this.serviceCodeList() == null) {
            return false;
        }
        if (other.serviceCodeList() != null && !other.serviceCodeList().equals(this.serviceCodeList())) {
            return false;
        }
        if (other.language() == null ^ this.language() == null) {
            return false;
        }
        return other.language() == null || other.language().equals(this.language());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serviceCodeList() != null) {
            sb.append("ServiceCodeList: ").append(this.serviceCodeList()).append(",");
        }
        if (this.language() != null) {
            sb.append("Language: ").append(this.language()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> serviceCodeList;
        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesRequest model) {
            this.setServiceCodeList(model.serviceCodeList);
            this.setLanguage(model.language);
        }

        public final Collection<String> getServiceCodeList() {
            return this.serviceCodeList;
        }

        @Override
        public final Builder serviceCodeList(Collection<String> serviceCodeList) {
            this.serviceCodeList = ServiceCodeListCopier.copy(serviceCodeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodeList(String ... serviceCodeList) {
            this.serviceCodeList(Arrays.asList(serviceCodeList));
            return this;
        }

        public final void setServiceCodeList(Collection<String> serviceCodeList) {
            this.serviceCodeList = ServiceCodeListCopier.copy(serviceCodeList);
        }

        public final String getLanguage() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public DescribeServicesRequest build() {
            return new DescribeServicesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeServicesRequest> {
        public Builder serviceCodeList(Collection<String> var1);

        public Builder serviceCodeList(String ... var1);

        public Builder language(String var1);
    }
}

