/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.support.model.Attachment;
import software.amazon.awssdk.services.support.model.AttachmentsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddAttachmentsToSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddAttachmentsToSetRequest> {
    private final String attachmentSetId;
    private final List<Attachment> attachments;

    private AddAttachmentsToSetRequest(BuilderImpl builder) {
        this.attachmentSetId = builder.attachmentSetId;
        this.attachments = builder.attachments;
    }

    public String attachmentSetId() {
        return this.attachmentSetId;
    }

    public List<Attachment> attachments() {
        return this.attachments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attachmentSetId() == null ? 0 : this.attachmentSetId().hashCode());
        hashCode = 31 * hashCode + (this.attachments() == null ? 0 : this.attachments().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddAttachmentsToSetRequest)) {
            return false;
        }
        AddAttachmentsToSetRequest other = (AddAttachmentsToSetRequest)((Object)obj);
        if (other.attachmentSetId() == null ^ this.attachmentSetId() == null) {
            return false;
        }
        if (other.attachmentSetId() != null && !other.attachmentSetId().equals(this.attachmentSetId())) {
            return false;
        }
        if (other.attachments() == null ^ this.attachments() == null) {
            return false;
        }
        return other.attachments() == null || other.attachments().equals(this.attachments());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachmentSetId() != null) {
            sb.append("AttachmentSetId: ").append(this.attachmentSetId()).append(",");
        }
        if (this.attachments() != null) {
            sb.append("Attachments: ").append(this.attachments()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String attachmentSetId;
        private List<Attachment> attachments;

        private BuilderImpl() {
        }

        private BuilderImpl(AddAttachmentsToSetRequest model) {
            this.setAttachmentSetId(model.attachmentSetId);
            this.setAttachments(model.attachments);
        }

        public final String getAttachmentSetId() {
            return this.attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        public final Collection<Attachment> getAttachments() {
            return this.attachments;
        }

        @Override
        public final Builder attachments(Collection<Attachment> attachments) {
            this.attachments = AttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Attachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        public final void setAttachments(Collection<Attachment> attachments) {
            this.attachments = AttachmentsCopier.copy(attachments);
        }

        public AddAttachmentsToSetRequest build() {
            return new AddAttachmentsToSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddAttachmentsToSetRequest> {
        public Builder attachmentSetId(String var1);

        public Builder attachments(Collection<Attachment> var1);

        public Builder attachments(Attachment ... var1);
    }
}

