/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.StringListCopier;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCheckDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TrustedAdvisorCheckDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, TrustedAdvisorCheckDescription> {
    private final String id;
    private final String name;
    private final String description;
    private final String category;
    private final List<String> metadata;

    private TrustedAdvisorCheckDescription(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.category = builder.category;
        this.metadata = builder.metadata;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String category() {
        return this.category;
    }

    public List<String> metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.category() == null ? 0 : this.category().hashCode());
        hashCode = 31 * hashCode + (this.metadata() == null ? 0 : this.metadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckDescription)) {
            return false;
        }
        TrustedAdvisorCheckDescription other = (TrustedAdvisorCheckDescription)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.category() == null ^ this.category() == null) {
            return false;
        }
        if (other.category() != null && !other.category().equals(this.category())) {
            return false;
        }
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        return other.metadata() == null || other.metadata().equals(this.metadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.category() != null) {
            sb.append("Category: ").append(this.category()).append(",");
        }
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCheckDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private String category;
        private List<String> metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckDescription model) {
            this.setId(model.id);
            this.setName(model.name);
            this.setDescription(model.description);
            this.setCategory(model.category);
            this.setMetadata(model.metadata);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final Collection<String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(String ... metadata) {
            this.metadata(Arrays.asList(metadata));
            return this;
        }

        public final void setMetadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
        }

        @SafeVarargs
        public final void setMetadata(String ... metadata) {
            this.metadata(Arrays.asList(metadata));
        }

        public TrustedAdvisorCheckDescription build() {
            return new TrustedAdvisorCheckDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrustedAdvisorCheckDescription> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder category(String var1);

        public Builder metadata(Collection<String> var1);

        public Builder metadata(String ... var1);
    }
}

