/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.support.model.CaseDetails;
import software.amazon.awssdk.services.support.model.CaseListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCasesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCasesResponse> {
    private final List<CaseDetails> cases;
    private final String nextToken;

    private DescribeCasesResponse(BuilderImpl builder) {
        this.cases = builder.cases;
        this.nextToken = builder.nextToken;
    }

    public List<CaseDetails> cases() {
        return this.cases;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cases() == null ? 0 : this.cases().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCasesResponse)) {
            return false;
        }
        DescribeCasesResponse other = (DescribeCasesResponse)((Object)obj);
        if (other.cases() == null ^ this.cases() == null) {
            return false;
        }
        if (other.cases() != null && !other.cases().equals(this.cases())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cases() != null) {
            sb.append("Cases: ").append(this.cases()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<CaseDetails> cases;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCasesResponse model) {
            this.setCases(model.cases);
            this.setNextToken(model.nextToken);
        }

        public final Collection<CaseDetails> getCases() {
            return this.cases;
        }

        @Override
        public final Builder cases(Collection<CaseDetails> cases) {
            this.cases = CaseListCopier.copy(cases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(CaseDetails ... cases) {
            this.cases(Arrays.asList(cases));
            return this;
        }

        public final void setCases(Collection<CaseDetails> cases) {
            this.cases = CaseListCopier.copy(cases);
        }

        @SafeVarargs
        public final void setCases(CaseDetails ... cases) {
            this.cases(Arrays.asList(cases));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeCasesResponse build() {
            return new DescribeCasesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCasesResponse> {
        public Builder cases(Collection<CaseDetails> var1);

        public Builder cases(CaseDetails ... var1);

        public Builder nextToken(String var1);
    }
}

