/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.CaseDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CaseDetailsMarshaller {
    private static final MarshallingInfo<String> CASEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("caseId").isBinary(false).build();
    private static final MarshallingInfo<String> DISPLAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("displayId").isBinary(false).build();
    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subject").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceCode").isBinary(false).build();
    private static final MarshallingInfo<String> CATEGORYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("categoryCode").isBinary(false).build();
    private static final MarshallingInfo<String> SEVERITYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("severityCode").isBinary(false).build();
    private static final MarshallingInfo<String> SUBMITTEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("submittedBy").isBinary(false).build();
    private static final MarshallingInfo<String> TIMECREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeCreated").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RECENTCOMMUNICATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recentCommunications").isBinary(false).build();
    private static final MarshallingInfo<List> CCEMAILADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ccEmailAddresses").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("language").isBinary(false).build();
    private static final CaseDetailsMarshaller INSTANCE = new CaseDetailsMarshaller();

    private CaseDetailsMarshaller() {
    }

    public static CaseDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CaseDetails caseDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)caseDetails, (String)"caseDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)caseDetails.caseId(), CASEID_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.displayId(), DISPLAYID_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.subject(), SUBJECT_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.serviceCode(), SERVICECODE_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.categoryCode(), CATEGORYCODE_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.severityCode(), SEVERITYCODE_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.submittedBy(), SUBMITTEDBY_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.timeCreated(), TIMECREATED_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.recentCommunications(), RECENTCOMMUNICATIONS_BINDING);
            protocolMarshaller.marshall(caseDetails.ccEmailAddresses(), CCEMAILADDRESSES_BINDING);
            protocolMarshaller.marshall((Object)caseDetails.language(), LANGUAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

