/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.support.SupportAsyncClient;
import software.amazon.awssdk.services.support.model.Communication;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsResponse;

public class DescribeCommunicationsPublisher
implements SdkPublisher<DescribeCommunicationsResponse> {
    private final SupportAsyncClient client;
    private final DescribeCommunicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCommunicationsPublisher(SupportAsyncClient client, DescribeCommunicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCommunicationsPublisher(SupportAsyncClient client, DescribeCommunicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCommunicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCommunicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Communication> communications() {
        Function<DescribeCommunicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.communications() != null) {
                return response.communications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCommunicationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeCommunicationsPublisher resume(DescribeCommunicationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCommunicationsPublisher(this.client, (DescribeCommunicationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeCommunicationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeCommunicationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeCommunicationsResponseFetcher
    implements AsyncPageFetcher<DescribeCommunicationsResponse> {
        private DescribeCommunicationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCommunicationsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<DescribeCommunicationsResponse> nextPage(DescribeCommunicationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCommunicationsPublisher.this.client.describeCommunications(DescribeCommunicationsPublisher.this.firstRequest);
            }
            return DescribeCommunicationsPublisher.this.client.describeCommunications((DescribeCommunicationsRequest)((Object)DescribeCommunicationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

