/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.support.model.Service;
import software.amazon.awssdk.services.support.model.ServiceListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeServicesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeServicesResponse> {
    private final List<Service> services;

    private DescribeServicesResponse(BuilderImpl builder) {
        this.services = builder.services;
    }

    public List<Service> services() {
        return this.services;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.services() == null ? 0 : this.services().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesResponse)) {
            return false;
        }
        DescribeServicesResponse other = (DescribeServicesResponse)((Object)obj);
        if (other.services() == null ^ this.services() == null) {
            return false;
        }
        return other.services() == null || other.services().equals(this.services());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.services() != null) {
            sb.append("Services: ").append(this.services()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Service> services = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesResponse model) {
            this.setServices(model.services);
        }

        public final Collection<Service> getServices() {
            return this.services;
        }

        @Override
        public final Builder services(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Service ... services) {
            if (this.services == null) {
                this.services = new SdkInternalList(services.length);
            }
            for (Service e : services) {
                this.services.add(e);
            }
            return this;
        }

        public final void setServices(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
        }

        @SafeVarargs
        public final void setServices(Service ... services) {
            if (this.services == null) {
                this.services = new SdkInternalList(services.length);
            }
            for (Service e : services) {
                this.services.add(e);
            }
        }

        public DescribeServicesResponse build() {
            return new DescribeServicesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeServicesResponse> {
        public Builder services(Collection<Service> var1);

        public Builder services(Service ... var1);
    }
}

