/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationEventDatasetOperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationEventDatasetTargetConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationEventDatasetTargetConfiguration> {
    private static final SdkField<String> DATASET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetIdentifier").getter(DataIntegrationEventDatasetTargetConfiguration.getter(DataIntegrationEventDatasetTargetConfiguration::datasetIdentifier)).setter(DataIntegrationEventDatasetTargetConfiguration.setter(Builder::datasetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetIdentifier").build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationType").getter(DataIntegrationEventDatasetTargetConfiguration.getter(DataIntegrationEventDatasetTargetConfiguration::operationTypeAsString)).setter(DataIntegrationEventDatasetTargetConfiguration.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IDENTIFIER_FIELD, OPERATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataIntegrationEventDatasetTargetConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String datasetIdentifier;
    private final String operationType;

    private DataIntegrationEventDatasetTargetConfiguration(BuilderImpl builder) {
        this.datasetIdentifier = builder.datasetIdentifier;
        this.operationType = builder.operationType;
    }

    public final String datasetIdentifier() {
        return this.datasetIdentifier;
    }

    public final DataIntegrationEventDatasetOperationType operationType() {
        return DataIntegrationEventDatasetOperationType.fromValue(this.operationType);
    }

    public final String operationTypeAsString() {
        return this.operationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationEventDatasetTargetConfiguration)) {
            return false;
        }
        DataIntegrationEventDatasetTargetConfiguration other = (DataIntegrationEventDatasetTargetConfiguration)obj;
        return Objects.equals(this.datasetIdentifier(), other.datasetIdentifier()) && Objects.equals(this.operationTypeAsString(), other.operationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationEventDatasetTargetConfiguration").add("DatasetIdentifier", (Object)this.datasetIdentifier()).add("OperationType", (Object)this.operationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.datasetIdentifier()));
            }
            case "operationType": {
                return Optional.ofNullable(clazz.cast(this.operationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("datasetIdentifier", DATASET_IDENTIFIER_FIELD);
        map.put("operationType", OPERATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationEventDatasetTargetConfiguration, T> g) {
        return obj -> g.apply((DataIntegrationEventDatasetTargetConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasetIdentifier;
        private String operationType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationEventDatasetTargetConfiguration model) {
            this.datasetIdentifier(model.datasetIdentifier);
            this.operationType(model.operationType);
        }

        public final String getDatasetIdentifier() {
            return this.datasetIdentifier;
        }

        public final void setDatasetIdentifier(String datasetIdentifier) {
            this.datasetIdentifier = datasetIdentifier;
        }

        @Override
        public final Builder datasetIdentifier(String datasetIdentifier) {
            this.datasetIdentifier = datasetIdentifier;
            return this;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(DataIntegrationEventDatasetOperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public DataIntegrationEventDatasetTargetConfiguration build() {
            return new DataIntegrationEventDatasetTargetConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationEventDatasetTargetConfiguration> {
        public Builder datasetIdentifier(String var1);

        public Builder operationType(String var1);

        public Builder operationType(DataIntegrationEventDatasetOperationType var1);
    }
}

