/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supplychain.SupplyChainAsyncClient;
import software.amazon.awssdk.services.supplychain.internal.UserAgentUtils;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationEvent;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationEventsResponse;

public class ListDataIntegrationEventsPublisher
implements SdkPublisher<ListDataIntegrationEventsResponse> {
    private final SupplyChainAsyncClient client;
    private final ListDataIntegrationEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataIntegrationEventsPublisher(SupplyChainAsyncClient client, ListDataIntegrationEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataIntegrationEventsPublisher(SupplyChainAsyncClient client, ListDataIntegrationEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataIntegrationEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataIntegrationEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataIntegrationEvent> events() {
        Function<ListDataIntegrationEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataIntegrationEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataIntegrationEventsResponseFetcher
    implements AsyncPageFetcher<ListDataIntegrationEventsResponse> {
        private ListDataIntegrationEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataIntegrationEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataIntegrationEventsResponse> nextPage(ListDataIntegrationEventsResponse previousPage) {
            if (previousPage == null) {
                return ListDataIntegrationEventsPublisher.this.client.listDataIntegrationEvents(ListDataIntegrationEventsPublisher.this.firstRequest);
            }
            return ListDataIntegrationEventsPublisher.this.client.listDataIntegrationEvents((ListDataIntegrationEventsRequest)((Object)ListDataIntegrationEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

