/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.supplychain.model.DataLakeDatasetSchemaField;
import software.amazon.awssdk.services.supplychain.model.DataLakeDatasetSchemaFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLakeDatasetSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLakeDatasetSchema> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DataLakeDatasetSchema.getter(DataLakeDatasetSchema::name)).setter(DataLakeDatasetSchema.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<DataLakeDatasetSchemaField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fields").getter(DataLakeDatasetSchema.getter(DataLakeDatasetSchema::fields)).setter(DataLakeDatasetSchema.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataLakeDatasetSchemaField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("fields", FIELDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<DataLakeDatasetSchemaField> fields;

    private DataLakeDatasetSchema(BuilderImpl builder) {
        this.name = builder.name;
        this.fields = builder.fields;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<DataLakeDatasetSchemaField> fields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeDatasetSchema)) {
            return false;
        }
        DataLakeDatasetSchema other = (DataLakeDatasetSchema)obj;
        return Objects.equals(this.name(), other.name()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields());
    }

    public final String toString() {
        return ToString.builder((String)"DataLakeDatasetSchema").add("Name", (Object)this.name()).add("Fields", this.hasFields() ? this.fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeDatasetSchema, T> g) {
        return obj -> g.apply((DataLakeDatasetSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<DataLakeDatasetSchemaField> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeDatasetSchema model) {
            this.name(model.name);
            this.fields(model.fields);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<DataLakeDatasetSchemaField.Builder> getFields() {
            List<DataLakeDatasetSchemaField.Builder> result = DataLakeDatasetSchemaFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<DataLakeDatasetSchemaField.BuilderImpl> fields) {
            this.fields = DataLakeDatasetSchemaFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<DataLakeDatasetSchemaField> fields) {
            this.fields = DataLakeDatasetSchemaFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(DataLakeDatasetSchemaField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<DataLakeDatasetSchemaField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (DataLakeDatasetSchemaField)((DataLakeDatasetSchemaField.Builder)DataLakeDatasetSchemaField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DataLakeDatasetSchema build() {
            return new DataLakeDatasetSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLakeDatasetSchema> {
        public Builder name(String var1);

        public Builder fields(Collection<DataLakeDatasetSchemaField> var1);

        public Builder fields(DataLakeDatasetSchemaField ... var1);

        public Builder fields(Consumer<DataLakeDatasetSchemaField.Builder> ... var1);
    }
}

