/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowSource;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowSourceListCopier;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowTarget;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowTransformation;
import software.amazon.awssdk.services.supplychain.model.SupplyChainRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataIntegrationFlowRequest
extends SupplyChainRequest
implements ToCopyableBuilder<Builder, UpdateDataIntegrationFlowRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(UpdateDataIntegrationFlowRequest.getter(UpdateDataIntegrationFlowRequest::instanceId)).setter(UpdateDataIntegrationFlowRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("instanceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateDataIntegrationFlowRequest.getter(UpdateDataIntegrationFlowRequest::name)).setter(UpdateDataIntegrationFlowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<List<DataIntegrationFlowSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(UpdateDataIntegrationFlowRequest.getter(UpdateDataIntegrationFlowRequest::sources)).setter(UpdateDataIntegrationFlowRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataIntegrationFlowSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataIntegrationFlowTransformation> TRANSFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("transformation").getter(UpdateDataIntegrationFlowRequest.getter(UpdateDataIntegrationFlowRequest::transformation)).setter(UpdateDataIntegrationFlowRequest.setter(Builder::transformation)).constructor(DataIntegrationFlowTransformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformation").build()}).build();
    private static final SdkField<DataIntegrationFlowTarget> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("target").getter(UpdateDataIntegrationFlowRequest.getter(UpdateDataIntegrationFlowRequest::target)).setter(UpdateDataIntegrationFlowRequest.setter(Builder::target)).constructor(DataIntegrationFlowTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD, SOURCES_FIELD, TRANSFORMATION_FIELD, TARGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDataIntegrationFlowRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String name;
    private final List<DataIntegrationFlowSource> sources;
    private final DataIntegrationFlowTransformation transformation;
    private final DataIntegrationFlowTarget target;

    private UpdateDataIntegrationFlowRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.sources = builder.sources;
        this.transformation = builder.transformation;
        this.target = builder.target;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<DataIntegrationFlowSource> sources() {
        return this.sources;
    }

    public final DataIntegrationFlowTransformation transformation() {
        return this.transformation;
    }

    public final DataIntegrationFlowTarget target() {
        return this.target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataIntegrationFlowRequest)) {
            return false;
        }
        UpdateDataIntegrationFlowRequest other = (UpdateDataIntegrationFlowRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.name(), other.name()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.transformation(), other.transformation()) && Objects.equals(this.target(), other.target());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataIntegrationFlowRequest").add("InstanceId", (Object)this.instanceId()).add("Name", (Object)this.name()).add("Sources", this.hasSources() ? this.sources() : null).add("Transformation", (Object)this.transformation()).add("Target", (Object)this.target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "transformation": {
                return Optional.ofNullable(clazz.cast(this.transformation()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("transformation", TRANSFORMATION_FIELD);
        map.put("target", TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataIntegrationFlowRequest, T> g) {
        return obj -> g.apply((UpdateDataIntegrationFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupplyChainRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String name;
        private List<DataIntegrationFlowSource> sources = DefaultSdkAutoConstructList.getInstance();
        private DataIntegrationFlowTransformation transformation;
        private DataIntegrationFlowTarget target;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataIntegrationFlowRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.name(model.name);
            this.sources(model.sources);
            this.transformation(model.transformation);
            this.target(model.target);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<DataIntegrationFlowSource.Builder> getSources() {
            List<DataIntegrationFlowSource.Builder> result = DataIntegrationFlowSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<DataIntegrationFlowSource.BuilderImpl> sources) {
            this.sources = DataIntegrationFlowSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<DataIntegrationFlowSource> sources) {
            this.sources = DataIntegrationFlowSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(DataIntegrationFlowSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<DataIntegrationFlowSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (DataIntegrationFlowSource)((DataIntegrationFlowSource.Builder)DataIntegrationFlowSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataIntegrationFlowTransformation.Builder getTransformation() {
            return this.transformation != null ? this.transformation.toBuilder() : null;
        }

        public final void setTransformation(DataIntegrationFlowTransformation.BuilderImpl transformation) {
            this.transformation = transformation != null ? transformation.build() : null;
        }

        @Override
        public final Builder transformation(DataIntegrationFlowTransformation transformation) {
            this.transformation = transformation;
            return this;
        }

        public final DataIntegrationFlowTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(DataIntegrationFlowTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(DataIntegrationFlowTarget target) {
            this.target = target;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataIntegrationFlowRequest build() {
            return new UpdateDataIntegrationFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SupplyChainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataIntegrationFlowRequest> {
        public Builder instanceId(String var1);

        public Builder name(String var1);

        public Builder sources(Collection<DataIntegrationFlowSource> var1);

        public Builder sources(DataIntegrationFlowSource ... var1);

        public Builder sources(Consumer<DataIntegrationFlowSource.Builder> ... var1);

        public Builder transformation(DataIntegrationFlowTransformation var1);

        default public Builder transformation(Consumer<DataIntegrationFlowTransformation.Builder> transformation) {
            return this.transformation((DataIntegrationFlowTransformation)((DataIntegrationFlowTransformation.Builder)DataIntegrationFlowTransformation.builder().applyMutation(transformation)).build());
        }

        public Builder target(DataIntegrationFlowTarget var1);

        default public Builder target(Consumer<DataIntegrationFlowTarget.Builder> target) {
            return this.target((DataIntegrationFlowTarget)((DataIntegrationFlowTarget.Builder)DataIntegrationFlowTarget.builder().applyMutation(target)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

