/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataIntegrationEventType {
    SCN_DATA_FORECAST("scn.data.forecast"),
    SCN_DATA_INVENTORYLEVEL("scn.data.inventorylevel"),
    SCN_DATA_INBOUNDORDER("scn.data.inboundorder"),
    SCN_DATA_INBOUNDORDERLINE("scn.data.inboundorderline"),
    SCN_DATA_INBOUNDORDERLINESCHEDULE("scn.data.inboundorderlineschedule"),
    SCN_DATA_OUTBOUNDORDERLINE("scn.data.outboundorderline"),
    SCN_DATA_OUTBOUNDSHIPMENT("scn.data.outboundshipment"),
    SCN_DATA_PROCESSHEADER("scn.data.processheader"),
    SCN_DATA_PROCESSOPERATION("scn.data.processoperation"),
    SCN_DATA_PROCESSPRODUCT("scn.data.processproduct"),
    SCN_DATA_RESERVATION("scn.data.reservation"),
    SCN_DATA_SHIPMENT("scn.data.shipment"),
    SCN_DATA_SHIPMENTSTOP("scn.data.shipmentstop"),
    SCN_DATA_SHIPMENTSTOPORDER("scn.data.shipmentstoporder"),
    SCN_DATA_SUPPLYPLAN("scn.data.supplyplan"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataIntegrationEventType> VALUE_MAP;
    private final String value;

    private DataIntegrationEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataIntegrationEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataIntegrationEventType> knownValues() {
        EnumSet<DataIntegrationEventType> knownValues = EnumSet.allOf(DataIntegrationEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataIntegrationEventType.class, DataIntegrationEventType::toString);
    }
}

