/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowDatasetSourceConfiguration;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowS3SourceConfiguration;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationFlowSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationFlowSource> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceType").getter(DataIntegrationFlowSource.getter(DataIntegrationFlowSource::sourceTypeAsString)).setter(DataIntegrationFlowSource.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceName").getter(DataIntegrationFlowSource.getter(DataIntegrationFlowSource::sourceName)).setter(DataIntegrationFlowSource.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()}).build();
    private static final SdkField<DataIntegrationFlowS3SourceConfiguration> S3_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Source").getter(DataIntegrationFlowSource.getter(DataIntegrationFlowSource::s3Source)).setter(DataIntegrationFlowSource.setter(Builder::s3Source)).constructor(DataIntegrationFlowS3SourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Source").build()}).build();
    private static final SdkField<DataIntegrationFlowDatasetSourceConfiguration> DATASET_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasetSource").getter(DataIntegrationFlowSource.getter(DataIntegrationFlowSource::datasetSource)).setter(DataIntegrationFlowSource.setter(Builder::datasetSource)).constructor(DataIntegrationFlowDatasetSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD, SOURCE_NAME_FIELD, S3_SOURCE_FIELD, DATASET_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sourceType", SOURCE_TYPE_FIELD);
            this.put("sourceName", SOURCE_NAME_FIELD);
            this.put("s3Source", S3_SOURCE_FIELD);
            this.put("datasetSource", DATASET_SOURCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String sourceType;
    private final String sourceName;
    private final DataIntegrationFlowS3SourceConfiguration s3Source;
    private final DataIntegrationFlowDatasetSourceConfiguration datasetSource;

    private DataIntegrationFlowSource(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.sourceName = builder.sourceName;
        this.s3Source = builder.s3Source;
        this.datasetSource = builder.datasetSource;
    }

    public final DataIntegrationFlowSourceType sourceType() {
        return DataIntegrationFlowSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final DataIntegrationFlowS3SourceConfiguration s3Source() {
        return this.s3Source;
    }

    public final DataIntegrationFlowDatasetSourceConfiguration datasetSource() {
        return this.datasetSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Source());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowSource)) {
            return false;
        }
        DataIntegrationFlowSource other = (DataIntegrationFlowSource)obj;
        return Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.sourceName(), other.sourceName()) && Objects.equals(this.s3Source(), other.s3Source()) && Objects.equals(this.datasetSource(), other.datasetSource());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationFlowSource").add("SourceType", (Object)this.sourceTypeAsString()).add("SourceName", (Object)this.sourceName()).add("S3Source", (Object)this.s3Source()).add("DatasetSource", (Object)this.datasetSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "sourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
            case "s3Source": {
                return Optional.ofNullable(clazz.cast(this.s3Source()));
            }
            case "datasetSource": {
                return Optional.ofNullable(clazz.cast(this.datasetSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowSource, T> g) {
        return obj -> g.apply((DataIntegrationFlowSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private String sourceName;
        private DataIntegrationFlowS3SourceConfiguration s3Source;
        private DataIntegrationFlowDatasetSourceConfiguration datasetSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowSource model) {
            this.sourceType(model.sourceType);
            this.sourceName(model.sourceName);
            this.s3Source(model.s3Source);
            this.datasetSource(model.datasetSource);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(DataIntegrationFlowSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final DataIntegrationFlowS3SourceConfiguration.Builder getS3Source() {
            return this.s3Source != null ? this.s3Source.toBuilder() : null;
        }

        public final void setS3Source(DataIntegrationFlowS3SourceConfiguration.BuilderImpl s3Source) {
            this.s3Source = s3Source != null ? s3Source.build() : null;
        }

        @Override
        public final Builder s3Source(DataIntegrationFlowS3SourceConfiguration s3Source) {
            this.s3Source = s3Source;
            return this;
        }

        public final DataIntegrationFlowDatasetSourceConfiguration.Builder getDatasetSource() {
            return this.datasetSource != null ? this.datasetSource.toBuilder() : null;
        }

        public final void setDatasetSource(DataIntegrationFlowDatasetSourceConfiguration.BuilderImpl datasetSource) {
            this.datasetSource = datasetSource != null ? datasetSource.build() : null;
        }

        @Override
        public final Builder datasetSource(DataIntegrationFlowDatasetSourceConfiguration datasetSource) {
            this.datasetSource = datasetSource;
            return this;
        }

        public DataIntegrationFlowSource build() {
            return new DataIntegrationFlowSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationFlowSource> {
        public Builder sourceType(String var1);

        public Builder sourceType(DataIntegrationFlowSourceType var1);

        public Builder sourceName(String var1);

        public Builder s3Source(DataIntegrationFlowS3SourceConfiguration var1);

        default public Builder s3Source(Consumer<DataIntegrationFlowS3SourceConfiguration.Builder> s3Source) {
            return this.s3Source((DataIntegrationFlowS3SourceConfiguration)((DataIntegrationFlowS3SourceConfiguration.Builder)DataIntegrationFlowS3SourceConfiguration.builder().applyMutation(s3Source)).build());
        }

        public Builder datasetSource(DataIntegrationFlowDatasetSourceConfiguration var1);

        default public Builder datasetSource(Consumer<DataIntegrationFlowDatasetSourceConfiguration.Builder> datasetSource) {
            return this.datasetSource((DataIntegrationFlowDatasetSourceConfiguration)((DataIntegrationFlowDatasetSourceConfiguration.Builder)DataIntegrationFlowDatasetSourceConfiguration.builder().applyMutation(datasetSource)).build());
        }
    }
}

