/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowDatasetTargetConfiguration;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowS3TargetConfiguration;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowTargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationFlowTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationFlowTarget> {
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetType").getter(DataIntegrationFlowTarget.getter(DataIntegrationFlowTarget::targetTypeAsString)).setter(DataIntegrationFlowTarget.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()}).build();
    private static final SdkField<DataIntegrationFlowS3TargetConfiguration> S3_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Target").getter(DataIntegrationFlowTarget.getter(DataIntegrationFlowTarget::s3Target)).setter(DataIntegrationFlowTarget.setter(Builder::s3Target)).constructor(DataIntegrationFlowS3TargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Target").build()}).build();
    private static final SdkField<DataIntegrationFlowDatasetTargetConfiguration> DATASET_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasetTarget").getter(DataIntegrationFlowTarget.getter(DataIntegrationFlowTarget::datasetTarget)).setter(DataIntegrationFlowTarget.setter(Builder::datasetTarget)).constructor(DataIntegrationFlowDatasetTargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TYPE_FIELD, S3_TARGET_FIELD, DATASET_TARGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("targetType", TARGET_TYPE_FIELD);
            this.put("s3Target", S3_TARGET_FIELD);
            this.put("datasetTarget", DATASET_TARGET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String targetType;
    private final DataIntegrationFlowS3TargetConfiguration s3Target;
    private final DataIntegrationFlowDatasetTargetConfiguration datasetTarget;

    private DataIntegrationFlowTarget(BuilderImpl builder) {
        this.targetType = builder.targetType;
        this.s3Target = builder.s3Target;
        this.datasetTarget = builder.datasetTarget;
    }

    public final DataIntegrationFlowTargetType targetType() {
        return DataIntegrationFlowTargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    public final DataIntegrationFlowS3TargetConfiguration s3Target() {
        return this.s3Target;
    }

    public final DataIntegrationFlowDatasetTargetConfiguration datasetTarget() {
        return this.datasetTarget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Target());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetTarget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowTarget)) {
            return false;
        }
        DataIntegrationFlowTarget other = (DataIntegrationFlowTarget)obj;
        return Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.s3Target(), other.s3Target()) && Objects.equals(this.datasetTarget(), other.datasetTarget());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationFlowTarget").add("TargetType", (Object)this.targetTypeAsString()).add("S3Target", (Object)this.s3Target()).add("DatasetTarget", (Object)this.datasetTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "s3Target": {
                return Optional.ofNullable(clazz.cast(this.s3Target()));
            }
            case "datasetTarget": {
                return Optional.ofNullable(clazz.cast(this.datasetTarget()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowTarget, T> g) {
        return obj -> g.apply((DataIntegrationFlowTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetType;
        private DataIntegrationFlowS3TargetConfiguration s3Target;
        private DataIntegrationFlowDatasetTargetConfiguration datasetTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowTarget model) {
            this.targetType(model.targetType);
            this.s3Target(model.s3Target);
            this.datasetTarget(model.datasetTarget);
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(DataIntegrationFlowTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final DataIntegrationFlowS3TargetConfiguration.Builder getS3Target() {
            return this.s3Target != null ? this.s3Target.toBuilder() : null;
        }

        public final void setS3Target(DataIntegrationFlowS3TargetConfiguration.BuilderImpl s3Target) {
            this.s3Target = s3Target != null ? s3Target.build() : null;
        }

        @Override
        public final Builder s3Target(DataIntegrationFlowS3TargetConfiguration s3Target) {
            this.s3Target = s3Target;
            return this;
        }

        public final DataIntegrationFlowDatasetTargetConfiguration.Builder getDatasetTarget() {
            return this.datasetTarget != null ? this.datasetTarget.toBuilder() : null;
        }

        public final void setDatasetTarget(DataIntegrationFlowDatasetTargetConfiguration.BuilderImpl datasetTarget) {
            this.datasetTarget = datasetTarget != null ? datasetTarget.build() : null;
        }

        @Override
        public final Builder datasetTarget(DataIntegrationFlowDatasetTargetConfiguration datasetTarget) {
            this.datasetTarget = datasetTarget;
            return this;
        }

        public DataIntegrationFlowTarget build() {
            return new DataIntegrationFlowTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationFlowTarget> {
        public Builder targetType(String var1);

        public Builder targetType(DataIntegrationFlowTargetType var1);

        public Builder s3Target(DataIntegrationFlowS3TargetConfiguration var1);

        default public Builder s3Target(Consumer<DataIntegrationFlowS3TargetConfiguration.Builder> s3Target) {
            return this.s3Target((DataIntegrationFlowS3TargetConfiguration)((DataIntegrationFlowS3TargetConfiguration.Builder)DataIntegrationFlowS3TargetConfiguration.builder().applyMutation(s3Target)).build());
        }

        public Builder datasetTarget(DataIntegrationFlowDatasetTargetConfiguration var1);

        default public Builder datasetTarget(Consumer<DataIntegrationFlowDatasetTargetConfiguration.Builder> datasetTarget) {
            return this.datasetTarget((DataIntegrationFlowDatasetTargetConfiguration)((DataIntegrationFlowDatasetTargetConfiguration.Builder)DataIntegrationFlowDatasetTargetConfiguration.builder().applyMutation(datasetTarget)).build());
        }
    }
}

