/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowS3Options;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationFlowS3SourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationFlowS3SourceConfiguration> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(DataIntegrationFlowS3SourceConfiguration.getter(DataIntegrationFlowS3SourceConfiguration::bucketName)).setter(DataIntegrationFlowS3SourceConfiguration.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prefix").getter(DataIntegrationFlowS3SourceConfiguration.getter(DataIntegrationFlowS3SourceConfiguration::prefix)).setter(DataIntegrationFlowS3SourceConfiguration.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()}).build();
    private static final SdkField<DataIntegrationFlowS3Options> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("options").getter(DataIntegrationFlowS3SourceConfiguration.getter(DataIntegrationFlowS3SourceConfiguration::options)).setter(DataIntegrationFlowS3SourceConfiguration.setter(Builder::options)).constructor(DataIntegrationFlowS3Options::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, PREFIX_FIELD, OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String prefix;
    private final DataIntegrationFlowS3Options options;

    private DataIntegrationFlowS3SourceConfiguration(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.options = builder.options;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final DataIntegrationFlowS3Options options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowS3SourceConfiguration)) {
            return false;
        }
        DataIntegrationFlowS3SourceConfiguration other = (DataIntegrationFlowS3SourceConfiguration)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationFlowS3SourceConfiguration").add("BucketName", (Object)this.bucketName()).add("Prefix", (Object)this.prefix()).add("Options", (Object)this.options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowS3SourceConfiguration, T> g) {
        return obj -> g.apply((DataIntegrationFlowS3SourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String prefix;
        private DataIntegrationFlowS3Options options;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowS3SourceConfiguration model) {
            this.bucketName(model.bucketName);
            this.prefix(model.prefix);
            this.options(model.options);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final DataIntegrationFlowS3Options.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(DataIntegrationFlowS3Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(DataIntegrationFlowS3Options options) {
            this.options = options;
            return this;
        }

        public DataIntegrationFlowS3SourceConfiguration build() {
            return new DataIntegrationFlowS3SourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationFlowS3SourceConfiguration> {
        public Builder bucketName(String var1);

        public Builder prefix(String var1);

        public Builder options(DataIntegrationFlowS3Options var1);

        default public Builder options(Consumer<DataIntegrationFlowS3Options.Builder> options) {
            return this.options((DataIntegrationFlowS3Options)((DataIntegrationFlowS3Options.Builder)DataIntegrationFlowS3Options.builder().applyMutation(options)).build());
        }
    }
}

