/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.ConfigurationJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BillOfMaterialsImportJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BillOfMaterialsImportJob> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(BillOfMaterialsImportJob.getter(BillOfMaterialsImportJob::instanceId)).setter(BillOfMaterialsImportJob.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(BillOfMaterialsImportJob.getter(BillOfMaterialsImportJob::jobId)).setter(BillOfMaterialsImportJob.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(BillOfMaterialsImportJob.getter(BillOfMaterialsImportJob::statusAsString)).setter(BillOfMaterialsImportJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3uri").getter(BillOfMaterialsImportJob.getter(BillOfMaterialsImportJob::s3uri)).setter(BillOfMaterialsImportJob.setter(Builder::s3uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3uri").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(BillOfMaterialsImportJob.getter(BillOfMaterialsImportJob::message)).setter(BillOfMaterialsImportJob.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, JOB_ID_FIELD, STATUS_FIELD, S3_URI_FIELD, MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String jobId;
    private final String status;
    private final String s3uri;
    private final String message;

    private BillOfMaterialsImportJob(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.s3uri = builder.s3uri;
        this.message = builder.message;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final ConfigurationJobStatus status() {
        return ConfigurationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String s3uri() {
        return this.s3uri;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillOfMaterialsImportJob)) {
            return false;
        }
        BillOfMaterialsImportJob other = (BillOfMaterialsImportJob)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.s3uri(), other.s3uri()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"BillOfMaterialsImportJob").add("InstanceId", (Object)this.instanceId()).add("JobId", (Object)this.jobId()).add("Status", (Object)this.statusAsString()).add("S3uri", (Object)this.s3uri()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "s3uri": {
                return Optional.ofNullable(clazz.cast(this.s3uri()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BillOfMaterialsImportJob, T> g) {
        return obj -> g.apply((BillOfMaterialsImportJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String jobId;
        private String status;
        private String s3uri;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BillOfMaterialsImportJob model) {
            this.instanceId(model.instanceId);
            this.jobId(model.jobId);
            this.status(model.status);
            this.s3uri(model.s3uri);
            this.message(model.message);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConfigurationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getS3uri() {
            return this.s3uri;
        }

        public final void setS3uri(String s3uri) {
            this.s3uri = s3uri;
        }

        @Override
        public final Builder s3uri(String s3uri) {
            this.s3uri = s3uri;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public BillOfMaterialsImportJob build() {
            return new BillOfMaterialsImportJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BillOfMaterialsImportJob> {
        public Builder instanceId(String var1);

        public Builder jobId(String var1);

        public Builder status(String var1);

        public Builder status(ConfigurationJobStatus var1);

        public Builder s3uri(String var1);

        public Builder message(String var1);
    }
}

