/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDelegatedAccessTokenResponse extends StsResponse implements
        ToCopyableBuilder<GetDelegatedAccessTokenResponse.Builder, GetDelegatedAccessTokenResponse> {
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.<Credentials> builder(MarshallingType.SDK_POJO)
            .memberName("Credentials").getter(getter(GetDelegatedAccessTokenResponse::credentials))
            .setter(setter(Builder::credentials)).constructor(Credentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();

    private static final SdkField<Integer> PACKED_POLICY_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PackedPolicySize").getter(getter(GetDelegatedAccessTokenResponse::packedPolicySize))
            .setter(setter(Builder::packedPolicySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackedPolicySize").build()).build();

    private static final SdkField<String> ASSUMED_PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssumedPrincipal").getter(getter(GetDelegatedAccessTokenResponse::assumedPrincipal))
            .setter(setter(Builder::assumedPrincipal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumedPrincipal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD,
            PACKED_POLICY_SIZE_FIELD, ASSUMED_PRINCIPAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Credentials credentials;

    private final Integer packedPolicySize;

    private final String assumedPrincipal;

    private GetDelegatedAccessTokenResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.packedPolicySize = builder.packedPolicySize;
        this.assumedPrincipal = builder.assumedPrincipal;
    }

    /**
     * Returns the value of the Credentials property for this object.
     * 
     * @return The value of the Credentials property for this object.
     */
    public final Credentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The percentage of the maximum policy size that is used by the session policy. The policy size is calculated as
     * the sum of all the session policies and permission boundaries attached to the session. If the packed size exceeds
     * 100%, the request fails.
     * </p>
     * 
     * @return The percentage of the maximum policy size that is used by the session policy. The policy size is
     *         calculated as the sum of all the session policies and permission boundaries attached to the session. If
     *         the packed size exceeds 100%, the request fails.
     */
    public final Integer packedPolicySize() {
        return packedPolicySize;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the principal that was assumed when obtaining the delegated access token. This
     * ARN identifies the IAM entity whose permissions are granted by the temporary credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the principal that was assumed when obtaining the delegated access
     *         token. This ARN identifies the IAM entity whose permissions are granted by the temporary credentials.
     */
    public final String assumedPrincipal() {
        return assumedPrincipal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(packedPolicySize());
        hashCode = 31 * hashCode + Objects.hashCode(assumedPrincipal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDelegatedAccessTokenResponse)) {
            return false;
        }
        GetDelegatedAccessTokenResponse other = (GetDelegatedAccessTokenResponse) obj;
        return Objects.equals(credentials(), other.credentials()) && Objects.equals(packedPolicySize(), other.packedPolicySize())
                && Objects.equals(assumedPrincipal(), other.assumedPrincipal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDelegatedAccessTokenResponse").add("Credentials", credentials())
                .add("PackedPolicySize", packedPolicySize()).add("AssumedPrincipal", assumedPrincipal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "PackedPolicySize":
            return Optional.ofNullable(clazz.cast(packedPolicySize()));
        case "AssumedPrincipal":
            return Optional.ofNullable(clazz.cast(assumedPrincipal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Credentials", CREDENTIALS_FIELD);
        map.put("PackedPolicySize", PACKED_POLICY_SIZE_FIELD);
        map.put("AssumedPrincipal", ASSUMED_PRINCIPAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDelegatedAccessTokenResponse, T> g) {
        return obj -> g.apply((GetDelegatedAccessTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDelegatedAccessTokenResponse> {
        /**
         * Sets the value of the Credentials property for this object.
         *
         * @param credentials
         *        The new value for the Credentials property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);

        /**
         * Sets the value of the Credentials property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Credentials.Builder} avoiding the need to
         * create one manually via {@link Credentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Credentials.Builder#build()} is called immediately and its result
         * is passed to {@link #credentials(Credentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(Credentials)
         */
        default Builder credentials(Consumer<Credentials.Builder> credentials) {
            return credentials(Credentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The percentage of the maximum policy size that is used by the session policy. The policy size is calculated
         * as the sum of all the session policies and permission boundaries attached to the session. If the packed size
         * exceeds 100%, the request fails.
         * </p>
         * 
         * @param packedPolicySize
         *        The percentage of the maximum policy size that is used by the session policy. The policy size is
         *        calculated as the sum of all the session policies and permission boundaries attached to the session.
         *        If the packed size exceeds 100%, the request fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packedPolicySize(Integer packedPolicySize);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the principal that was assumed when obtaining the delegated access token.
         * This ARN identifies the IAM entity whose permissions are granted by the temporary credentials.
         * </p>
         * 
         * @param assumedPrincipal
         *        The Amazon Resource Name (ARN) of the principal that was assumed when obtaining the delegated access
         *        token. This ARN identifies the IAM entity whose permissions are granted by the temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumedPrincipal(String assumedPrincipal);
    }

    static final class BuilderImpl extends StsResponse.BuilderImpl implements Builder {
        private Credentials credentials;

        private Integer packedPolicySize;

        private String assumedPrincipal;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDelegatedAccessTokenResponse model) {
            super(model);
            credentials(model.credentials);
            packedPolicySize(model.packedPolicySize);
            assumedPrincipal(model.assumedPrincipal);
        }

        public final Credentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Integer getPackedPolicySize() {
            return packedPolicySize;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final String getAssumedPrincipal() {
            return assumedPrincipal;
        }

        public final void setAssumedPrincipal(String assumedPrincipal) {
            this.assumedPrincipal = assumedPrincipal;
        }

        @Override
        public final Builder assumedPrincipal(String assumedPrincipal) {
            this.assumedPrincipal = assumedPrincipal;
            return this;
        }

        @Override
        public GetDelegatedAccessTokenResponse build() {
            return new GetDelegatedAccessTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
