/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWebIdentityTokenResponse extends StsResponse implements
        ToCopyableBuilder<GetWebIdentityTokenResponse.Builder, GetWebIdentityTokenResponse> {
    private static final SdkField<String> WEB_IDENTITY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebIdentityToken").getter(getter(GetWebIdentityTokenResponse::webIdentityToken))
            .setter(setter(Builder::webIdentityToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebIdentityToken").build()).build();

    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Expiration").getter(getter(GetWebIdentityTokenResponse::expiration)).setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_IDENTITY_TOKEN_FIELD,
            EXPIRATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String webIdentityToken;

    private final Instant expiration;

    private GetWebIdentityTokenResponse(BuilderImpl builder) {
        super(builder);
        this.webIdentityToken = builder.webIdentityToken;
        this.expiration = builder.expiration;
    }

    /**
     * <p>
     * A signed JSON Web Token (JWT) that represents the caller's Amazon Web Services identity. The token contains
     * standard JWT claims such as subject, audience, expiration time, and additional identity attributes added by STS
     * as custom claims. You can also add your own custom claims to the token by passing tags as request parameters to
     * the <code>GetWebIdentityToken</code> API. The token is signed using the specified signing algorithm and can be
     * verified using the verification keys available at the issuer's JWKS endpoint.
     * </p>
     * 
     * @return A signed JSON Web Token (JWT) that represents the caller's Amazon Web Services identity. The token
     *         contains standard JWT claims such as subject, audience, expiration time, and additional identity
     *         attributes added by STS as custom claims. You can also add your own custom claims to the token by passing
     *         tags as request parameters to the <code>GetWebIdentityToken</code> API. The token is signed using the
     *         specified signing algorithm and can be verified using the verification keys available at the issuer's
     *         JWKS endpoint.
     */
    public final String webIdentityToken() {
        return webIdentityToken;
    }

    /**
     * <p>
     * The date and time when the web identity token expires, in UTC. The expiration is determined by adding the
     * <code>DurationSeconds</code> value to the time the token was issued. After this time, the token should no longer
     * be considered valid.
     * </p>
     * 
     * @return The date and time when the web identity token expires, in UTC. The expiration is determined by adding the
     *         <code>DurationSeconds</code> value to the time the token was issued. After this time, the token should no
     *         longer be considered valid.
     */
    public final Instant expiration() {
        return expiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webIdentityToken());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebIdentityTokenResponse)) {
            return false;
        }
        GetWebIdentityTokenResponse other = (GetWebIdentityTokenResponse) obj;
        return Objects.equals(webIdentityToken(), other.webIdentityToken()) && Objects.equals(expiration(), other.expiration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWebIdentityTokenResponse")
                .add("WebIdentityToken", webIdentityToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Expiration", expiration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebIdentityToken":
            return Optional.ofNullable(clazz.cast(webIdentityToken()));
        case "Expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WebIdentityToken", WEB_IDENTITY_TOKEN_FIELD);
        map.put("Expiration", EXPIRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWebIdentityTokenResponse, T> g) {
        return obj -> g.apply((GetWebIdentityTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWebIdentityTokenResponse> {
        /**
         * <p>
         * A signed JSON Web Token (JWT) that represents the caller's Amazon Web Services identity. The token contains
         * standard JWT claims such as subject, audience, expiration time, and additional identity attributes added by
         * STS as custom claims. You can also add your own custom claims to the token by passing tags as request
         * parameters to the <code>GetWebIdentityToken</code> API. The token is signed using the specified signing
         * algorithm and can be verified using the verification keys available at the issuer's JWKS endpoint.
         * </p>
         * 
         * @param webIdentityToken
         *        A signed JSON Web Token (JWT) that represents the caller's Amazon Web Services identity. The token
         *        contains standard JWT claims such as subject, audience, expiration time, and additional identity
         *        attributes added by STS as custom claims. You can also add your own custom claims to the token by
         *        passing tags as request parameters to the <code>GetWebIdentityToken</code> API. The token is signed
         *        using the specified signing algorithm and can be verified using the verification keys available at the
         *        issuer's JWKS endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webIdentityToken(String webIdentityToken);

        /**
         * <p>
         * The date and time when the web identity token expires, in UTC. The expiration is determined by adding the
         * <code>DurationSeconds</code> value to the time the token was issued. After this time, the token should no
         * longer be considered valid.
         * </p>
         * 
         * @param expiration
         *        The date and time when the web identity token expires, in UTC. The expiration is determined by adding
         *        the <code>DurationSeconds</code> value to the time the token was issued. After this time, the token
         *        should no longer be considered valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Instant expiration);
    }

    static final class BuilderImpl extends StsResponse.BuilderImpl implements Builder {
        private String webIdentityToken;

        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebIdentityTokenResponse model) {
            super(model);
            webIdentityToken(model.webIdentityToken);
            expiration(model.expiration);
        }

        public final String getWebIdentityToken() {
            return webIdentityToken;
        }

        public final void setWebIdentityToken(String webIdentityToken) {
            this.webIdentityToken = webIdentityToken;
        }

        @Override
        public final Builder webIdentityToken(String webIdentityToken) {
            this.webIdentityToken = webIdentityToken;
            return this;
        }

        public final Instant getExpiration() {
            return expiration;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        @Override
        public GetWebIdentityTokenResponse build() {
            return new GetWebIdentityTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
