/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.protocols.query.interceptor.QueryParametersToBodyInterceptor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.DefaultStsAsyncClient;
import software.amazon.awssdk.services.sts.DefaultStsBaseClientBuilder;
import software.amazon.awssdk.services.sts.StsAsyncClient;
import software.amazon.awssdk.services.sts.StsAsyncClientBuilder;
import software.amazon.awssdk.services.sts.StsServiceClientConfiguration;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointProvider;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
final class DefaultStsAsyncClientBuilder
extends DefaultStsBaseClientBuilder<StsAsyncClientBuilder, StsAsyncClient>
implements StsAsyncClientBuilder {
    DefaultStsAsyncClientBuilder() {
    }

    @Override
    public DefaultStsAsyncClientBuilder endpointProvider(StsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final StsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        List interceptors = (List)clientConfiguration.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS);
        List<QueryParametersToBodyInterceptor> queryParamsToBodyInterceptor = Collections.singletonList(new QueryParametersToBodyInterceptor());
        ArrayList customizationInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(queryParamsToBodyInterceptor, (List)interceptors);
        interceptors = CollectionUtils.mergeLists(customizationInterceptors, (List)interceptors);
        clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
        DefaultStsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        StsServiceClientConfiguration serviceClientConfiguration = StsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultStsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

