/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.DefaultStsAsyncClient;
import software.amazon.awssdk.services.sts.DefaultStsBaseClientBuilder;
import software.amazon.awssdk.services.sts.StsAsyncClient;
import software.amazon.awssdk.services.sts.StsAsyncClientBuilder;
import software.amazon.awssdk.services.sts.StsServiceClientConfiguration;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointProvider;

@SdkInternalApi
final class DefaultStsAsyncClientBuilder
extends DefaultStsBaseClientBuilder<StsAsyncClientBuilder, StsAsyncClient>
implements StsAsyncClientBuilder {
    DefaultStsAsyncClientBuilder() {
    }

    @Override
    public DefaultStsAsyncClientBuilder endpointProvider(StsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final StsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultStsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        StsServiceClientConfiguration serviceClientConfiguration = StsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultStsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

