/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public class StsGetSessionTokenCredentialsProvider
extends StsCredentialsProvider {
    private final GetSessionTokenRequest getSessionTokenRequest;

    private StsGetSessionTokenCredentialsProvider(Builder builder) {
        super(builder, "sts-get-token-credentials-provider");
        Validate.notNull((Object)((Object)builder.getSessionTokenRequest), (String)"Get session token request must not be null.", (Object[])new Object[0]);
        this.getSessionTokenRequest = builder.getSessionTokenRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Credentials getUpdatedCredentials(StsClient stsClient) {
        return stsClient.getSessionToken(this.getSessionTokenRequest).credentials();
    }

    public String toString() {
        return ToString.builder((String)"StsGetSessionTokenCredentialsProvider").add("refreshRequest", (Object)this.getSessionTokenRequest).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsGetSessionTokenCredentialsProvider> {
        private GetSessionTokenRequest getSessionTokenRequest = (GetSessionTokenRequest)((Object)GetSessionTokenRequest.builder().build());

        private Builder() {
            super((B x$0) -> new StsGetSessionTokenCredentialsProvider((Builder)x$0));
        }

        public Builder refreshRequest(GetSessionTokenRequest getSessionTokenRequest) {
            this.getSessionTokenRequest = getSessionTokenRequest;
            return this;
        }

        public Builder refreshRequest(Consumer<GetSessionTokenRequest.Builder> getFederationTokenRequest) {
            return this.refreshRequest((GetSessionTokenRequest)((Object)((GetSessionTokenRequest.Builder)GetSessionTokenRequest.builder().applyMutation(getFederationTokenRequest)).build()));
        }

        @Override
        public StsGetSessionTokenCredentialsProvider build() {
            return (StsGetSessionTokenCredentialsProvider)super.build();
        }
    }
}

