/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public final class StsAssumeRoleCredentialsProvider
extends StsCredentialsProvider {
    private Supplier<AssumeRoleRequest> assumeRoleRequestSupplier;

    private StsAssumeRoleCredentialsProvider(Builder builder) {
        super(builder, "sts-assume-role-credentials-provider");
        Validate.notNull((Object)builder.assumeRoleRequestSupplier, (String)"Assume role request must not be null.", (Object[])new Object[0]);
        this.assumeRoleRequestSupplier = builder.assumeRoleRequestSupplier;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Credentials getUpdatedCredentials(StsClient stsClient) {
        AssumeRoleRequest assumeRoleRequest = this.assumeRoleRequestSupplier.get();
        Validate.notNull((Object)((Object)assumeRoleRequest), (String)"Assume role request must not be null.", (Object[])new Object[0]);
        return stsClient.assumeRole(assumeRoleRequest).credentials();
    }

    public String toString() {
        return ToString.builder((String)"StsAssumeRoleCredentialsProvider").add("refreshRequest", this.assumeRoleRequestSupplier).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsAssumeRoleCredentialsProvider> {
        private Supplier<AssumeRoleRequest> assumeRoleRequestSupplier;

        private Builder() {
            super((B x$0) -> new StsAssumeRoleCredentialsProvider((Builder)x$0));
        }

        public Builder refreshRequest(AssumeRoleRequest assumeRoleRequest) {
            return this.refreshRequest(() -> assumeRoleRequest);
        }

        public Builder refreshRequest(Supplier<AssumeRoleRequest> assumeRoleRequestSupplier) {
            this.assumeRoleRequestSupplier = assumeRoleRequestSupplier;
            return this;
        }

        public Builder refreshRequest(Consumer<AssumeRoleRequest.Builder> assumeRoleRequest) {
            return this.refreshRequest((AssumeRoleRequest)((Object)((AssumeRoleRequest.Builder)AssumeRoleRequest.builder().applyMutation(assumeRoleRequest)).build()));
        }
    }
}

