/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public class StsGetFederationTokenCredentialsProvider
extends StsCredentialsProvider {
    private final GetFederationTokenRequest getFederationTokenRequest;

    private StsGetFederationTokenCredentialsProvider(Builder builder) {
        super(builder, "sts-get-federation-token-credentials-provider");
        Validate.notNull((Object)((Object)builder.getFederationTokenRequest), (String)"Get session token request must not be null.", (Object[])new Object[0]);
        this.getFederationTokenRequest = builder.getFederationTokenRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Credentials getUpdatedCredentials(StsClient stsClient) {
        return stsClient.getFederationToken(this.getFederationTokenRequest).credentials();
    }

    public String toString() {
        return ToString.builder((String)"StsGetFederationTokenCredentialsProvider").add("refreshRequest", (Object)this.getFederationTokenRequest).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsGetFederationTokenCredentialsProvider> {
        private GetFederationTokenRequest getFederationTokenRequest;

        private Builder() {
            super((B x$0) -> new StsGetFederationTokenCredentialsProvider((Builder)x$0));
        }

        public Builder refreshRequest(GetFederationTokenRequest getFederationTokenRequest) {
            this.getFederationTokenRequest = getFederationTokenRequest;
            return this;
        }

        public Builder refreshRequest(Consumer<GetFederationTokenRequest.Builder> getFederationTokenRequest) {
            return this.refreshRequest((GetFederationTokenRequest)((Object)((GetFederationTokenRequest.Builder)GetFederationTokenRequest.builder().applyMutation(getFederationTokenRequest)).build()));
        }
    }
}

