/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.sts.STSClient;
import software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@ThreadSafe
public class StsAssumeRoleWithWebIdentityCredentialsProvider
extends StsCredentialsProvider {
    private final AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest;

    private StsAssumeRoleWithWebIdentityCredentialsProvider(Builder builder) {
        super(builder, "sts-assume-role-with-web-identity-credentials-provider");
        Validate.notNull((Object)((Object)builder.assumeRoleWithWebIdentityRequest), (String)"Assume role with web identity request must not be null.", (Object[])new Object[0]);
        this.assumeRoleWithWebIdentityRequest = builder.assumeRoleWithWebIdentityRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Credentials getUpdatedCredentials(STSClient stsClient) {
        return stsClient.assumeRoleWithWebIdentity(this.assumeRoleWithWebIdentityRequest).credentials();
    }

    public String toString() {
        return ToString.builder((String)"StsAssumeRoleWithWebIdentityCredentialsProvider").add("refreshRequest", (Object)this.assumeRoleWithWebIdentityRequest).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsAssumeRoleWithWebIdentityCredentialsProvider> {
        private AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest;

        private Builder() {
            super((B x$0) -> new StsAssumeRoleWithWebIdentityCredentialsProvider((Builder)x$0));
        }

        public Builder refreshRequest(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) {
            this.assumeRoleWithWebIdentityRequest = assumeRoleWithWebIdentityRequest;
            return this;
        }

        public Builder refreshRequest(Consumer<AssumeRoleWithWebIdentityRequest.Builder> assumeRoleWithWebIdentityRequest) {
            return this.refreshRequest((AssumeRoleWithWebIdentityRequest)((Object)((AssumeRoleWithWebIdentityRequest.Builder)AssumeRoleWithWebIdentityRequest.builder().apply(assumeRoleWithWebIdentityRequest)).build()));
        }
    }
}

