/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.StaxResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sts.STSClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSAMLRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSAMLResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse;
import software.amazon.awssdk.services.sts.model.ExpiredTokenException;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.sts.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import software.amazon.awssdk.services.sts.model.IDPCommunicationErrorException;
import software.amazon.awssdk.services.sts.model.IDPRejectedClaimException;
import software.amazon.awssdk.services.sts.model.InvalidAuthorizationMessageException;
import software.amazon.awssdk.services.sts.model.InvalidIdentityTokenException;
import software.amazon.awssdk.services.sts.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.sts.model.PackedPolicyTooLargeException;
import software.amazon.awssdk.services.sts.model.RegionDisabledException;
import software.amazon.awssdk.services.sts.model.STSException;
import software.amazon.awssdk.services.sts.transform.AssumeRoleRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithSAMLRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithSAMLResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithWebIdentityRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithWebIdentityResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.DecodeAuthorizationMessageRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.DecodeAuthorizationMessageResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.ExpiredTokenExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.GetCallerIdentityRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetCallerIdentityResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.GetFederationTokenRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetFederationTokenResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.GetSessionTokenRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetSessionTokenResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.IDPCommunicationErrorExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.IDPRejectedClaimExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.InvalidAuthorizationMessageExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.InvalidIdentityTokenExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.MalformedPolicyDocumentExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.PackedPolicyTooLargeExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.RegionDisabledExceptionUnmarshaller;

@SdkInternalApi
final class DefaultSTSClient
implements STSClient {
    private final ClientHandler clientHandler;
    private final List<Unmarshaller<SdkServiceException, Node>> exceptionUnmarshallers;
    private final ClientConfiguration clientConfiguration;

    protected DefaultSTSClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.exceptionUnmarshallers = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "sts";
    }

    @Override
    public AssumeRoleResponse assumeRole(AssumeRoleRequest assumeRoleRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, SdkServiceException, SdkClientException, STSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AssumeRoleResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (AssumeRoleResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)assumeRoleRequest).withMarshaller((Marshaller)new AssumeRoleRequestMarshaller()));
    }

    @Override
    public AssumeRoleWithSAMLResponse assumeRoleWithSAML(AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IDPRejectedClaimException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, SdkServiceException, SdkClientException, STSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AssumeRoleWithSAMLResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (AssumeRoleWithSAMLResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)assumeRoleWithSAMLRequest).withMarshaller((Marshaller)new AssumeRoleWithSAMLRequestMarshaller()));
    }

    @Override
    public AssumeRoleWithWebIdentityResponse assumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IDPRejectedClaimException, IDPCommunicationErrorException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, SdkServiceException, SdkClientException, STSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AssumeRoleWithWebIdentityResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (AssumeRoleWithWebIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)assumeRoleWithWebIdentityRequest).withMarshaller((Marshaller)new AssumeRoleWithWebIdentityRequestMarshaller()));
    }

    @Override
    public DecodeAuthorizationMessageResponse decodeAuthorizationMessage(DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) throws InvalidAuthorizationMessageException, SdkServiceException, SdkClientException, STSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DecodeAuthorizationMessageResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DecodeAuthorizationMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)decodeAuthorizationMessageRequest).withMarshaller((Marshaller)new DecodeAuthorizationMessageRequestMarshaller()));
    }

    @Override
    public GetCallerIdentityResponse getCallerIdentity(GetCallerIdentityRequest getCallerIdentityRequest) throws SdkServiceException, SdkClientException, STSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetCallerIdentityResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetCallerIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getCallerIdentityRequest).withMarshaller((Marshaller)new GetCallerIdentityRequestMarshaller()));
    }

    @Override
    public GetFederationTokenResponse getFederationToken(GetFederationTokenRequest getFederationTokenRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, SdkServiceException, SdkClientException, STSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetFederationTokenResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetFederationTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getFederationTokenRequest).withMarshaller((Marshaller)new GetFederationTokenRequestMarshaller()));
    }

    @Override
    public GetSessionTokenResponse getSessionToken(GetSessionTokenRequest getSessionTokenRequest) throws RegionDisabledException, SdkServiceException, SdkClientException, STSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetSessionTokenResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetSessionTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getSessionTokenRequest).withMarshaller((Marshaller)new GetSessionTokenRequestMarshaller()));
    }

    private List<Unmarshaller<SdkServiceException, Node>> init() {
        ArrayList<Unmarshaller<SdkServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<SdkServiceException, Node>>();
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new InvalidAuthorizationMessageExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new ExpiredTokenExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new PackedPolicyTooLargeExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new RegionDisabledExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new MalformedPolicyDocumentExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new IDPCommunicationErrorExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new InvalidIdentityTokenExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new IDPRejectedClaimExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new StandardErrorUnmarshaller(STSException.class));
        return unmarshallers;
    }

    public void close() {
        this.clientHandler.close();
    }
}

