/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sts.model.Credentials;

public class CredentialsUnmarshaller
implements Unmarshaller<Credentials, StaxUnmarshallerContext> {
    private static final CredentialsUnmarshaller INSTANCE = new CredentialsUnmarshaller();

    public Credentials unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Credentials.Builder credentials = Credentials.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AccessKeyId", targetDepth)) {
                    credentials.accessKeyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SecretAccessKey", targetDepth)) {
                    credentials.secretAccessKey(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SessionToken", targetDepth)) {
                    credentials.sessionToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Expiration", targetDepth)) continue;
                credentials.expiration(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Credentials)credentials.build();
    }

    public static CredentialsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

