/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;

public class AssumeRoleWithWebIdentityRequestMarshaller
implements Marshaller<Request<AssumeRoleWithWebIdentityRequest>, AssumeRoleWithWebIdentityRequest> {
    public Request<AssumeRoleWithWebIdentityRequest> marshall(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) {
        if (assumeRoleWithWebIdentityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)assumeRoleWithWebIdentityRequest, "STSClient");
        request.addParameter("Action", "AssumeRoleWithWebIdentity");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (assumeRoleWithWebIdentityRequest.roleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString((String)assumeRoleWithWebIdentityRequest.roleArn()));
        }
        if (assumeRoleWithWebIdentityRequest.roleSessionName() != null) {
            request.addParameter("RoleSessionName", StringUtils.fromString((String)assumeRoleWithWebIdentityRequest.roleSessionName()));
        }
        if (assumeRoleWithWebIdentityRequest.webIdentityToken() != null) {
            request.addParameter("WebIdentityToken", StringUtils.fromString((String)assumeRoleWithWebIdentityRequest.webIdentityToken()));
        }
        if (assumeRoleWithWebIdentityRequest.providerId() != null) {
            request.addParameter("ProviderId", StringUtils.fromString((String)assumeRoleWithWebIdentityRequest.providerId()));
        }
        if (assumeRoleWithWebIdentityRequest.policy() != null) {
            request.addParameter("Policy", StringUtils.fromString((String)assumeRoleWithWebIdentityRequest.policy()));
        }
        if (assumeRoleWithWebIdentityRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger((Integer)assumeRoleWithWebIdentityRequest.durationSeconds()));
        }
        return request;
    }
}

